/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.cms.bc;

import ccit.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import ccit.org.bouncycastle.cms.CMSException;
import ccit.org.bouncycastle.cms.RecipientOperator;
import ccit.org.bouncycastle.cms.bc.BcKEKRecipient;
import ccit.org.bouncycastle.cms.bc.EnvelopedDataHelper;
import ccit.org.bouncycastle.crypto.BufferedBlockCipher;
import ccit.org.bouncycastle.crypto.StreamCipher;
import ccit.org.bouncycastle.crypto.io.CipherInputStream;
import ccit.org.bouncycastle.crypto.params.KeyParameter;
import ccit.org.bouncycastle.operator.InputDecryptor;
import ccit.org.bouncycastle.operator.bc.BcSymmetricKeyUnwrapper;
import java.io.InputStream;

public class BcKEKEnvelopedRecipient
extends BcKEKRecipient {
    public BcKEKEnvelopedRecipient(BcSymmetricKeyUnwrapper bcSymmetricKeyUnwrapper) {
        super(bcSymmetricKeyUnwrapper);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier algorithmIdentifier, final AlgorithmIdentifier algorithmIdentifier2, byte[] byArray) throws CMSException {
        KeyParameter keyParameter = (KeyParameter)this.extractSecretKey(algorithmIdentifier, algorithmIdentifier2, byArray);
        final Object object = EnvelopedDataHelper.createContentCipher(false, keyParameter, algorithmIdentifier2);
        return new RecipientOperator(new InputDecryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier2;
            }

            @Override
            public InputStream getInputStream(InputStream inputStream) {
                if (object instanceof BufferedBlockCipher) {
                    return new CipherInputStream(inputStream, (BufferedBlockCipher)object);
                }
                return new CipherInputStream(inputStream, (StreamCipher)object);
            }
        });
    }
}

