/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.cms.jcajce;

import ccit.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import ccit.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import ccit.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import ccit.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import ccit.org.bouncycastle.cms.KEMKeyWrapper;
import ccit.org.bouncycastle.cms.KEMRecipientInfoGenerator;
import ccit.org.bouncycastle.cms.jcajce.JceCMSKEMKeyWrapper;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JceKEMRecipientInfoGenerator
extends KEMRecipientInfoGenerator {
    public JceKEMRecipientInfoGenerator(X509Certificate x509Certificate, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws CertificateEncodingException {
        super(new IssuerAndSerialNumber(new JcaX509CertificateHolder(x509Certificate).toASN1Structure()), (KEMKeyWrapper)new JceCMSKEMKeyWrapper(x509Certificate.getPublicKey(), aSN1ObjectIdentifier));
    }

    public JceKEMRecipientInfoGenerator(byte[] byArray, PublicKey publicKey, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        super(byArray, (KEMKeyWrapper)new JceCMSKEMKeyWrapper(publicKey, aSN1ObjectIdentifier));
    }

    public JceKEMRecipientInfoGenerator setProvider(String string) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setProvider(string);
        return this;
    }

    public JceKEMRecipientInfoGenerator setProvider(Provider provider) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setProvider(provider);
        return this;
    }

    public JceKEMRecipientInfoGenerator setSecureRandom(SecureRandom secureRandom) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setSecureRandom(secureRandom);
        return this;
    }

    public JceKEMRecipientInfoGenerator setKDF(AlgorithmIdentifier algorithmIdentifier) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setKDF(algorithmIdentifier);
        return this;
    }

    public JceKEMRecipientInfoGenerator setAlgorithmMapping(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setAlgorithmMapping(aSN1ObjectIdentifier, string);
        return this;
    }
}

