/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.crypto.ec;

import ccit.org.bouncycastle.crypto.CipherParameters;
import ccit.org.bouncycastle.crypto.ec.ECPair;
import ccit.org.bouncycastle.crypto.ec.ECPairFactorTransform;
import ccit.org.bouncycastle.crypto.params.ECDomainParameters;
import ccit.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import ccit.org.bouncycastle.math.ec.ECAlgorithms;
import ccit.org.bouncycastle.math.ec.ECMultiplier;
import ccit.org.bouncycastle.math.ec.ECPoint;
import ccit.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;

public class ECFixedTransform
implements ECPairFactorTransform {
    private ECPublicKeyParameters key;
    private BigInteger k;

    public ECFixedTransform(BigInteger bigInteger) {
        this.k = bigInteger;
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        if (!(cipherParameters instanceof ECPublicKeyParameters)) {
            throw new IllegalArgumentException("ECPublicKeyParameters are required for fixed transform.");
        }
        this.key = (ECPublicKeyParameters)cipherParameters;
    }

    @Override
    public ECPair transform(ECPair eCPair) {
        if (this.key == null) {
            throw new IllegalStateException("ECFixedTransform not initialised");
        }
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        BigInteger bigInteger = eCDomainParameters.getN();
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        BigInteger bigInteger2 = this.k.mod(bigInteger);
        ECPoint[] eCPointArray = new ECPoint[]{eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger2).add(ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPair.getX())), this.key.getQ().multiply(bigInteger2).add(ECAlgorithms.cleanPoint(eCDomainParameters.getCurve(), eCPair.getY()))};
        eCDomainParameters.getCurve().normalizeAll(eCPointArray);
        return new ECPair(eCPointArray[0], eCPointArray[1]);
    }

    @Override
    public BigInteger getTransformValue() {
        return this.k;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

