/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.crypto.generators;

import ccit.org.bouncycastle.crypto.CipherKeyGenerator;
import ccit.org.bouncycastle.crypto.CryptoServicePurpose;
import ccit.org.bouncycastle.crypto.CryptoServicesRegistrar;
import ccit.org.bouncycastle.crypto.KeyGenerationParameters;
import ccit.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import ccit.org.bouncycastle.crypto.params.DESParameters;

public class DESKeyGenerator
extends CipherKeyGenerator {
    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        super.init(keyGenerationParameters);
        if (this.strength == 0 || this.strength == 7) {
            this.strength = 8;
        } else if (this.strength != 8) {
            throw new IllegalArgumentException("DES key must be 64 bits long.");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("DESKeyGen", 56, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public byte[] generateKey() {
        byte[] byArray = new byte[8];
        do {
            this.random.nextBytes(byArray);
            DESParameters.setOddParity(byArray);
        } while (DESParameters.isWeakKey(byArray, 0));
        return byArray;
    }
}

