/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.crypto.generators;

import ccit.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import ccit.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import ccit.org.bouncycastle.crypto.CryptoServicePurpose;
import ccit.org.bouncycastle.crypto.CryptoServicesRegistrar;
import ccit.org.bouncycastle.crypto.KeyGenerationParameters;
import ccit.org.bouncycastle.crypto.constraints.ConstraintUtils;
import ccit.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import ccit.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import ccit.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import ccit.org.bouncycastle.crypto.params.DHParameters;
import ccit.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import ccit.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DHKeyGenerationParameters)keyGenerationParameters;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("DHKeyGen", ConstraintUtils.bitsOfSecurityFor(this.param.getParameters().getP()), this.param.getParameters(), CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dHParameters = this.param.getParameters();
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(bigInteger2, dHParameters), new DHPrivateKeyParameters(bigInteger, dHParameters));
    }
}

