/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.crypto.generators;

import ccit.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import ccit.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import ccit.org.bouncycastle.crypto.CryptoServicePurpose;
import ccit.org.bouncycastle.crypto.CryptoServicesRegistrar;
import ccit.org.bouncycastle.crypto.KeyGenerationParameters;
import ccit.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import ccit.org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import ccit.org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import java.security.SecureRandom;

public class Ed25519KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("Ed25519KeyGen", 128, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed25519PrivateKeyParameters ed25519PrivateKeyParameters = new Ed25519PrivateKeyParameters(this.random);
        Ed25519PublicKeyParameters ed25519PublicKeyParameters = ed25519PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(ed25519PublicKeyParameters, ed25519PrivateKeyParameters);
    }
}

