/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.dvcs;

import ccit.org.bouncycastle.cms.CMSException;
import ccit.org.bouncycastle.cms.CMSProcessableByteArray;
import ccit.org.bouncycastle.cms.CMSSignedData;
import ccit.org.bouncycastle.cms.CMSSignedDataGenerator;
import ccit.org.bouncycastle.dvcs.DVCSException;
import ccit.org.bouncycastle.dvcs.DVCSMessage;
import java.io.IOException;

public class SignedDVCSMessageGenerator {
    private final CMSSignedDataGenerator signedDataGen;

    public SignedDVCSMessageGenerator(CMSSignedDataGenerator cMSSignedDataGenerator) {
        this.signedDataGen = cMSSignedDataGenerator;
    }

    public CMSSignedData build(DVCSMessage dVCSMessage) throws DVCSException {
        try {
            byte[] byArray = dVCSMessage.getContent().toASN1Primitive().getEncoded("DER");
            return this.signedDataGen.generate(new CMSProcessableByteArray(dVCSMessage.getContentType(), byArray), true);
        }
        catch (CMSException cMSException) {
            throw new DVCSException("Could not sign DVCS request", cMSException);
        }
        catch (IOException iOException) {
            throw new DVCSException("Could not encode DVCS request", iOException);
        }
    }
}

