/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.est.jcajce;

import ccit.org.bouncycastle.est.ESTClient;
import ccit.org.bouncycastle.est.ESTClientProvider;
import ccit.org.bouncycastle.est.ESTException;
import ccit.org.bouncycastle.est.jcajce.ChannelBindingProvider;
import ccit.org.bouncycastle.est.jcajce.DefaultESTClient;
import ccit.org.bouncycastle.est.jcajce.DefaultESTClientSourceProvider;
import ccit.org.bouncycastle.est.jcajce.JsseHostnameAuthorizer;
import ccit.org.bouncycastle.est.jcajce.SSLSocketFactoryCreator;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;

class DefaultESTHttpClientProvider
implements ESTClientProvider {
    private final JsseHostnameAuthorizer hostNameAuthorizer;
    private final SSLSocketFactoryCreator socketFactoryCreator;
    private final int timeout;
    private final ChannelBindingProvider bindingProvider;
    private final Set<String> cipherSuites;
    private final Long absoluteLimit;
    private final boolean filterCipherSuites;

    public DefaultESTHttpClientProvider(JsseHostnameAuthorizer jsseHostnameAuthorizer, SSLSocketFactoryCreator sSLSocketFactoryCreator, int n, ChannelBindingProvider channelBindingProvider, Set<String> set, Long l, boolean bl) {
        this.hostNameAuthorizer = jsseHostnameAuthorizer;
        this.socketFactoryCreator = sSLSocketFactoryCreator;
        this.timeout = n;
        this.bindingProvider = channelBindingProvider;
        this.cipherSuites = set;
        this.absoluteLimit = l;
        this.filterCipherSuites = bl;
    }

    @Override
    public ESTClient makeClient() throws ESTException {
        try {
            SSLSocketFactory sSLSocketFactory = this.socketFactoryCreator.createFactory();
            return new DefaultESTClient(new DefaultESTClientSourceProvider(sSLSocketFactory, this.hostNameAuthorizer, this.timeout, this.bindingProvider, this.cipherSuites, this.absoluteLimit, this.filterCipherSuites));
        }
        catch (Exception exception) {
            throw new ESTException(exception.getMessage(), exception.getCause());
        }
    }

    @Override
    public boolean isTrusted() {
        return this.socketFactoryCreator.isTrusted();
    }
}

