/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.jcajce.provider.symmetric;

import ccit.org.bouncycastle.crypto.CipherKeyGenerator;
import ccit.org.bouncycastle.crypto.engines.XTEAEngine;
import ccit.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import ccit.org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import ccit.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import ccit.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import ccit.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class XTEA {
    private XTEA() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "XTEA IV";
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new XTEAEngine());
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("XTEA", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = XTEA.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.XTEA", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("KeyGenerator.XTEA", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.XTEA", PREFIX + "$AlgParams");
        }
    }
}

