/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.operator.bc;

import ccit.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import ccit.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import ccit.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import ccit.org.bouncycastle.crypto.AsymmetricBlockCipher;
import ccit.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import ccit.org.bouncycastle.crypto.engines.RSABlindedEngine;
import ccit.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import ccit.org.bouncycastle.crypto.util.PublicKeyFactory;
import ccit.org.bouncycastle.operator.bc.BcAsymmetricKeyWrapper;
import java.io.IOException;

public class BcRSAAsymmetricKeyWrapper
extends BcAsymmetricKeyWrapper {
    public BcRSAAsymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, AsymmetricKeyParameter asymmetricKeyParameter) {
        super(algorithmIdentifier, asymmetricKeyParameter);
    }

    public BcRSAAsymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        super(algorithmIdentifier, PublicKeyFactory.createKey(subjectPublicKeyInfo));
    }

    @Override
    protected AsymmetricBlockCipher createAsymmetricWrapper(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return new PKCS1Encoding(new RSABlindedEngine());
    }
}

