/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.operator.bc;

import ccit.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import ccit.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import ccit.org.bouncycastle.crypto.ExtendedDigest;
import ccit.org.bouncycastle.crypto.Signer;
import ccit.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import ccit.org.bouncycastle.crypto.signers.RSADigestSigner;
import ccit.org.bouncycastle.crypto.util.PublicKeyFactory;
import ccit.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import ccit.org.bouncycastle.operator.OperatorCreationException;
import ccit.org.bouncycastle.operator.bc.BcContentVerifierProviderBuilder;
import java.io.IOException;

public class BcRSAContentVerifierProviderBuilder
extends BcContentVerifierProviderBuilder {
    private DigestAlgorithmIdentifierFinder digestAlgorithmFinder;

    public BcRSAContentVerifierProviderBuilder(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgorithmFinder = digestAlgorithmIdentifierFinder;
    }

    @Override
    protected Signer createSigner(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        AlgorithmIdentifier algorithmIdentifier2 = this.digestAlgorithmFinder.find(algorithmIdentifier);
        ExtendedDigest extendedDigest = this.digestProvider.get(algorithmIdentifier2);
        return new RSADigestSigner(extendedDigest);
    }

    @Override
    protected AsymmetricKeyParameter extractKeyParameters(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        return PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }
}

