/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.pkcs.bc;

import ccit.org.bouncycastle.asn1.DERNull;
import ccit.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import ccit.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import ccit.org.bouncycastle.operator.MacCalculator;
import ccit.org.bouncycastle.operator.OperatorCreationException;
import ccit.org.bouncycastle.operator.bc.BcDigestProvider;
import ccit.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import ccit.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import ccit.org.bouncycastle.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private BcDigestProvider digestProvider;

    public BcPKCS12MacCalculatorBuilderProvider(BcDigestProvider bcDigestProvider) {
        this.digestProvider = bcDigestProvider;
    }

    @Override
    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            @Override
            public MacCalculator build(char[] cArray) throws OperatorCreationException {
                PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                return PKCS12PBEUtils.createMacCalculator(algorithmIdentifier.getAlgorithm(), BcPKCS12MacCalculatorBuilderProvider.this.digestProvider.get(algorithmIdentifier), pKCS12PBEParams, cArray);
            }

            @Override
            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

