/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.pqc.crypto.hqc;

import ccit.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import ccit.org.bouncycastle.crypto.SecretWithEncapsulation;
import ccit.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import ccit.org.bouncycastle.pqc.crypto.hqc.HQCEngine;
import ccit.org.bouncycastle.pqc.crypto.hqc.HQCPublicKeyParameters;
import ccit.org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import ccit.org.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class HQCKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public HQCKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        HQCPublicKeyParameters hQCPublicKeyParameters = (HQCPublicKeyParameters)asymmetricKeyParameter;
        HQCEngine hQCEngine = hQCPublicKeyParameters.getParameters().getEngine();
        byte[] byArray = new byte[hQCPublicKeyParameters.getParameters().getSHA512_BYTES()];
        byte[] byArray2 = new byte[hQCPublicKeyParameters.getParameters().getN_BYTES()];
        byte[] byArray3 = new byte[hQCPublicKeyParameters.getParameters().getN1N2_BYTES()];
        byte[] byArray4 = new byte[hQCPublicKeyParameters.getParameters().getSHA512_BYTES()];
        byte[] byArray5 = new byte[hQCPublicKeyParameters.getParameters().getSALT_SIZE_BYTES()];
        byte[] byArray6 = hQCPublicKeyParameters.getPublicKey();
        byte[] byArray7 = new byte[48];
        this.sr.nextBytes(byArray7);
        hQCEngine.encaps(byArray2, byArray3, byArray, byArray4, byArray6, byArray7, byArray5);
        byte[] byArray8 = Arrays.concatenate(byArray2, byArray3, byArray4, byArray5);
        return new SecretWithEncapsulationImpl(Arrays.copyOfRange(byArray, 0, hQCPublicKeyParameters.getParameters().getK()), byArray8);
    }
}

