/*
 * Decompiled with CFR 0.152.
 */
package ccit.org.bouncycastle.pqc.jcajce.provider.saber;

import ccit.org.bouncycastle.asn1.ASN1Set;
import ccit.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import ccit.org.bouncycastle.pqc.crypto.saber.SABERPrivateKeyParameters;
import ccit.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import ccit.org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import ccit.org.bouncycastle.pqc.jcajce.interfaces.SABERKey;
import ccit.org.bouncycastle.pqc.jcajce.spec.SABERParameterSpec;
import ccit.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;

public class BCSABERPrivateKey
implements PrivateKey,
SABERKey {
    private static final long serialVersionUID = 1L;
    private transient SABERPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCSABERPrivateKey(SABERPrivateKeyParameters sABERPrivateKeyParameters) {
        this.params = sABERPrivateKeyParameters;
    }

    public BCSABERPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (SABERPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCSABERPrivateKey) {
            BCSABERPrivateKey bCSABERPrivateKey = (BCSABERPrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCSABERPrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "SABER";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public SABERParameterSpec getParameterSpec() {
        return SABERParameterSpec.fromName(this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    SABERPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

