/*
 * Decompiled with CFR 0.152.
 */
package com.ccit.sm.sm4;

import ccit.org.bouncycastle.jce.provider.BouncyCastleProvider;
import ccit.org.bouncycastle.util.encoders.Hex;
import com.ccit.sm.exception.SmCryptoException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class SM4 {
    private static final String SM4_ALGORITHM = "SM4";
    private static final int DEFAULT_KEY_SIZE = 128;
    private static final String TRANSFORMATION_CBC = "SM4/CBC/PKCS5Padding";
    private static final String TRANSFORMATION_ECB = "SM4/ECB/PKCS5Padding";

    public static String generateKey() {
        return SM4.generateKey(128);
    }

    public static String generateKey(int keySize) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(SM4_ALGORITHM, "BC");
            kg.init(keySize, new SecureRandom());
            byte[] encoded = kg.generateKey().getEncoded();
            return Hex.toHexString(encoded).toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    public static String encrypt(String planText, String keyHex, String ivHex) {
        try {
            if (planText == null) {
                return null;
            }
            Cipher cipher = Cipher.getInstance(TRANSFORMATION_CBC);
            SecretKeySpec keySpec = new SecretKeySpec(Hex.decode(keyHex), SM4_ALGORITHM);
            IvParameterSpec ivSpec = new IvParameterSpec(Hex.decode(ivHex));
            cipher.init(1, (Key)keySpec, ivSpec);
            byte[] outputBytes = cipher.doFinal(planText.getBytes(StandardCharsets.UTF_8));
            return Hex.toHexString(outputBytes).toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    public static String decrypt(String cipherDataHex, String keyHex, String ivHex) {
        try {
            if (cipherDataHex == null) {
                return null;
            }
            Cipher cipher = Cipher.getInstance(TRANSFORMATION_CBC);
            SecretKeySpec keySpec = new SecretKeySpec(Hex.decode(keyHex), SM4_ALGORITHM);
            IvParameterSpec ivSpec = new IvParameterSpec(Hex.decode(ivHex));
            cipher.init(2, (Key)keySpec, ivSpec);
            byte[] outputBytes = cipher.doFinal(Hex.decode(cipherDataHex));
            return new String(outputBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    public static String encrypt(String planText, String keyHex) {
        try {
            if (planText == null) {
                return null;
            }
            Cipher cipher = Cipher.getInstance(TRANSFORMATION_ECB);
            SecretKeySpec keySpec = new SecretKeySpec(Hex.decode(keyHex), SM4_ALGORITHM);
            cipher.init(1, keySpec);
            byte[] outputBytes = cipher.doFinal(planText.getBytes(StandardCharsets.UTF_8));
            return Hex.toHexString(outputBytes).toUpperCase(Locale.ROOT);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    public static String decrypt(String cipherDataHex, String keyHex) {
        try {
            if (cipherDataHex == null) {
                return null;
            }
            Cipher cipher = Cipher.getInstance(TRANSFORMATION_ECB);
            SecretKeySpec keySpec = new SecretKeySpec(Hex.decode(keyHex), SM4_ALGORITHM);
            cipher.init(2, keySpec);
            byte[] outputBytes = cipher.doFinal(Hex.decode(cipherDataHex));
            return new String(outputBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new SmCryptoException(e);
        }
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

