/*
 * Decompiled with CFR 0.152.
 */
package com.ccit.sm.utils;

import com.ccit.sm.dto.CipherObj;
import com.ccit.sm.sm2.SM2;
import com.ccit.sm.sm3.SM3;
import com.ccit.sm.sm4.SM4;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

public class TransmissionUtils {
    private static final String STR1 = "newjourney";
    private static final String STR2 = "hiworld";
    private static final String STR3 = "G";

    private TransmissionUtils() {
    }

    public static String encrypt(String plaintext, String sm2PubKey) {
        long time = System.currentTimeMillis();
        String digestHex = SM3.getDigest(plaintext + STR1 + time);
        String sm4Key = SM4.generateKey();
        String splicingStr = SM4.encrypt(plaintext + STR1 + time + STR2 + digestHex, sm4Key, sm4Key);
        String sm4key = SM2.encrypt(sm4Key, sm2PubKey);
        return splicingStr + STR3 + sm4key;
    }

    public static String encrypt(String plaintext) {
        return TransmissionUtils.encrypt(plaintext, "0492ACDC618E2412C2C1080A5233AD875A606FA489208F4E0BE3B6119D3850F8B3893B612313DFA1DE6DC3C94D7B77EB382F0417A14C34592329E7F4B60FB981C2");
    }

    public static CipherObj decrypt(String cipherText, String sm2PriKey) throws StringIndexOutOfBoundsException, ArrayIndexOutOfBoundsException, NullPointerException {
        CipherObj result = new CipherObj();
        String splicingStr = cipherText.split(STR3)[0];
        String sm4key = cipherText.split(STR3)[1];
        String sm4SecretKey = SM2.decrypt(sm4key, sm2PriKey);
        String splicingStr0 = SM4.decrypt(splicingStr, sm4SecretKey, sm4SecretKey);
        String resultStr = splicingStr0.split(STR2)[0];
        String digestHex = splicingStr0.split(STR2)[1];
        if (digestHex.trim().equals(SM3.getDigest(resultStr).trim())) {
            result.setCipherText(resultStr.split(STR1)[0]);
            return result;
        }
        return result;
    }

    public static CipherObj decrypt(String cipherText) throws StringIndexOutOfBoundsException, ArrayIndexOutOfBoundsException, NullPointerException {
        return TransmissionUtils.decrypt(cipherText, "9ADAAD476D0B7F2795876D030B36927764D025016E15EAEF2FEA21B454F99EE2");
    }

    public static <T> T decrypt(String cipherText, String sm2PriKey, Class<T> clazz) throws StringIndexOutOfBoundsException, ArrayIndexOutOfBoundsException, NullPointerException, JsonProcessingException {
        String s = TransmissionUtils.decrypt(cipherText, sm2PriKey).getCipherText();
        if (clazz.getName().equals(String.class.getName())) {
            return (T)s;
        }
        return new ObjectMapper().readValue(s, clazz);
    }

    public static <T> T decrypt(String cipherText, Class<T> clazz) throws StringIndexOutOfBoundsException, ArrayIndexOutOfBoundsException, NullPointerException, JsonProcessingException {
        return TransmissionUtils.decrypt(cipherText, "9ADAAD476D0B7F2795876D030B36927764D025016E15EAEF2FEA21B454F99EE2", clazz);
    }
}

