/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.ParentContextApplicationContextInitializer;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.logging.LoggingApplicationListener;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.cloud.bootstrap.BootstrapImportSelectorConfiguration;
import org.springframework.cloud.bootstrap.LoggingSystemShutdownListener;
import org.springframework.cloud.bootstrap.encrypt.EnvironmentDecryptApplicationInitializer;
import org.springframework.cloud.bootstrap.support.OriginTrackedCompositePropertySource;
import org.springframework.cloud.util.PropertyUtils;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class BootstrapApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    public static final String BOOTSTRAP_PROPERTY_SOURCE_NAME = "bootstrap";
    public static final int DEFAULT_ORDER = -2147483643;
    public static final String DEFAULT_PROPERTIES = "springCloudDefaultProperties";
    private int order = -2147483643;

    @Override
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment2 = event.getEnvironment();
        if (!PropertyUtils.bootstrapEnabled(environment2) && !PropertyUtils.useLegacyProcessing(environment2)) {
            return;
        }
        if (environment2.getPropertySources().contains(BOOTSTRAP_PROPERTY_SOURCE_NAME)) {
            return;
        }
        ConfigurableApplicationContext context = null;
        String configName = environment2.resolvePlaceholders("${spring.cloud.bootstrap.name:bootstrap}");
        for (ApplicationContextInitializer<?> initializer : event.getSpringApplication().getInitializers()) {
            if (!(initializer instanceof ParentContextApplicationContextInitializer)) continue;
            context = this.findBootstrapContext((ParentContextApplicationContextInitializer)initializer, configName);
        }
        if (context == null) {
            context = this.bootstrapServiceContext(environment2, event.getSpringApplication(), configName);
            event.getSpringApplication().addListeners(new CloseContextOnFailureApplicationListener(context));
        }
        this.apply(context, event.getSpringApplication(), environment2);
    }

    private ConfigurableApplicationContext findBootstrapContext(ParentContextApplicationContextInitializer initializer, String configName) {
        Field field = ReflectionUtils.findField(ParentContextApplicationContextInitializer.class, "parent");
        ReflectionUtils.makeAccessible(field);
        ConfigurableApplicationContext parent = this.safeCast(ConfigurableApplicationContext.class, ReflectionUtils.getField(field, initializer));
        if (parent != null && !configName.equals(parent.getId())) {
            parent = this.safeCast(ConfigurableApplicationContext.class, parent.getParent());
        }
        return parent;
    }

    private <T> T safeCast(Class<T> type, Object object) {
        try {
            return type.cast(object);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private ConfigurableApplicationContext bootstrapServiceContext(ConfigurableEnvironment environment2, SpringApplication application, String configName) {
        AbstractEnvironment bootstrapEnvironment = new AbstractEnvironment(){};
        MutablePropertySources bootstrapProperties = bootstrapEnvironment.getPropertySources();
        String configLocation = environment2.resolvePlaceholders("${spring.cloud.bootstrap.location:}");
        String configAdditionalLocation = environment2.resolvePlaceholders("${spring.cloud.bootstrap.additional-location:}");
        HashMap<String, Object> bootstrapMap = new HashMap<String, Object>();
        bootstrapMap.put("spring.config.name", configName);
        bootstrapMap.put("spring.main.web-application-type", "none");
        if (StringUtils.hasText(configLocation)) {
            bootstrapMap.put("spring.config.location", configLocation);
        }
        if (StringUtils.hasText(configAdditionalLocation)) {
            bootstrapMap.put("spring.config.additional-location", configAdditionalLocation);
        }
        bootstrapProperties.addFirst(new MapPropertySource(BOOTSTRAP_PROPERTY_SOURCE_NAME, (Map<String, Object>)bootstrapMap));
        for (PropertySource<?> source : environment2.getPropertySources()) {
            if (source instanceof PropertySource.StubPropertySource) continue;
            bootstrapProperties.addLast(source);
        }
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[0]).profiles(environment2.getActiveProfiles()).bannerMode(Banner.Mode.OFF).environment(bootstrapEnvironment).registerShutdownHook(false).logStartupInfo(false).web(WebApplicationType.NONE);
        SpringApplication builderApplication = builder.application();
        if (builderApplication.getMainApplicationClass() == null) {
            builder.main(application.getMainApplicationClass());
        }
        if (environment2.getPropertySources().contains("refreshArgs")) {
            builderApplication.setListeners(this.filterListeners(builderApplication.getListeners()));
        }
        builder.sources(BootstrapImportSelectorConfiguration.class);
        ConfigurableApplicationContext context = builder.run(new String[0]);
        context.setId(BOOTSTRAP_PROPERTY_SOURCE_NAME);
        this.addAncestorInitializer(application, context);
        bootstrapProperties.remove(BOOTSTRAP_PROPERTY_SOURCE_NAME);
        this.mergeDefaultProperties(environment2.getPropertySources(), bootstrapProperties);
        return context;
    }

    private Collection<? extends ApplicationListener<?>> filterListeners(Set<ApplicationListener<?>> listeners) {
        LinkedHashSet result = new LinkedHashSet();
        for (ApplicationListener<?> listener : listeners) {
            if (listener instanceof LoggingApplicationListener || listener instanceof LoggingSystemShutdownListener) continue;
            result.add(listener);
        }
        return result;
    }

    private void mergeDefaultProperties(MutablePropertySources environment2, MutablePropertySources bootstrap) {
        String name = DEFAULT_PROPERTIES;
        if (bootstrap.contains(name)) {
            PropertySource<?> source = bootstrap.get(name);
            if (!environment2.contains(name)) {
                environment2.addLast(source);
            } else {
                PropertySource<?> target = environment2.get(name);
                if (target instanceof MapPropertySource && target != source && source instanceof MapPropertySource) {
                    Map targetMap = (Map)((MapPropertySource)target).getSource();
                    Map map = (Map)((MapPropertySource)source).getSource();
                    for (String key : map.keySet()) {
                        if (target.containsProperty(key)) continue;
                        targetMap.put(key, map.get(key));
                    }
                }
            }
        }
        this.mergeAdditionalPropertySources(environment2, bootstrap);
    }

    private void mergeAdditionalPropertySources(MutablePropertySources environment2, MutablePropertySources bootstrap) {
        PropertySource<?> defaultProperties = environment2.get(DEFAULT_PROPERTIES);
        ExtendedDefaultPropertySource result = defaultProperties instanceof ExtendedDefaultPropertySource ? (ExtendedDefaultPropertySource)defaultProperties : new ExtendedDefaultPropertySource(DEFAULT_PROPERTIES, defaultProperties);
        for (PropertySource<?> source : bootstrap) {
            if (environment2.contains(source.getName())) continue;
            result.add(source);
        }
        for (String name : result.getPropertySourceNames()) {
            bootstrap.remove(name);
        }
        this.addOrReplace(environment2, result);
        this.addOrReplace(bootstrap, result);
    }

    private void addOrReplace(MutablePropertySources environment2, PropertySource<?> result) {
        if (environment2.contains(result.getName())) {
            environment2.replace(result.getName(), result);
        } else {
            environment2.addLast(result);
        }
    }

    private void addAncestorInitializer(SpringApplication application, ConfigurableApplicationContext context) {
        boolean installed = false;
        for (ApplicationContextInitializer<?> initializer : application.getInitializers()) {
            if (!(initializer instanceof AncestorInitializer)) continue;
            installed = true;
            ((AncestorInitializer)initializer).setParent(context);
        }
        if (!installed) {
            application.addInitializers(new AncestorInitializer(context));
        }
    }

    private void apply(ConfigurableApplicationContext context, SpringApplication application, ConfigurableEnvironment environment2) {
        if (application.getAllSources().contains(BootstrapMarkerConfiguration.class)) {
            return;
        }
        application.addPrimarySources(Arrays.asList(BootstrapMarkerConfiguration.class));
        LinkedHashSet target = new LinkedHashSet(application.getInitializers());
        target.addAll(this.getOrderedBeansOfType(context, ApplicationContextInitializer.class));
        application.setInitializers(target);
        this.addBootstrapDecryptInitializer(application);
        environment2.setActiveProfiles(context.getEnvironment().getActiveProfiles());
    }

    private void addBootstrapDecryptInitializer(SpringApplication application) {
        DelegatingEnvironmentDecryptApplicationInitializer decrypter = null;
        LinkedHashSet<ApplicationContextInitializer<ConfigurableApplicationContext>> initializers = new LinkedHashSet<ApplicationContextInitializer<ConfigurableApplicationContext>>();
        for (ApplicationContextInitializer<ConfigurableApplicationContext> applicationContextInitializer : application.getInitializers()) {
            if (applicationContextInitializer instanceof EnvironmentDecryptApplicationInitializer) {
                ApplicationContextInitializer<ConfigurableApplicationContext> del = applicationContextInitializer;
                decrypter = new DelegatingEnvironmentDecryptApplicationInitializer(del);
                initializers.add(applicationContextInitializer);
                initializers.add(decrypter);
                continue;
            }
            if (applicationContextInitializer instanceof DelegatingEnvironmentDecryptApplicationInitializer) continue;
            initializers.add(applicationContextInitializer);
        }
        ArrayList target = new ArrayList(initializers);
        application.setInitializers(target);
    }

    private <T> List<T> getOrderedBeansOfType(ListableBeanFactory context, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        for (String name : context.getBeanNamesForType(type)) {
            result.add(context.getBean(name, type));
        }
        AnnotationAwareOrderComparator.sort(result);
        return result;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private static class CloseContextOnFailureApplicationListener
    implements SmartApplicationListener {
        private final ConfigurableApplicationContext context;

        CloseContextOnFailureApplicationListener(ConfigurableApplicationContext context) {
            this.context = context;
        }

        @Override
        public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
            return ApplicationFailedEvent.class.isAssignableFrom(eventType);
        }

        @Override
        public void onApplicationEvent(ApplicationEvent event) {
            if (event instanceof ApplicationFailedEvent) {
                this.context.close();
            }
        }
    }

    private static class ExtendedDefaultPropertySource
    extends SystemEnvironmentPropertySource
    implements OriginLookup<String> {
        private final OriginTrackedCompositePropertySource sources;
        private final List<String> names = new ArrayList<String>();

        ExtendedDefaultPropertySource(String name, PropertySource<?> propertySource) {
            super(name, ExtendedDefaultPropertySource.findMap(propertySource));
            this.sources = new OriginTrackedCompositePropertySource(name);
        }

        private static Map<String, Object> findMap(PropertySource<?> propertySource) {
            if (propertySource instanceof MapPropertySource) {
                return (Map)propertySource.getSource();
            }
            return new LinkedHashMap<String, Object>();
        }

        public CompositePropertySource getPropertySources() {
            return this.sources;
        }

        public List<String> getPropertySourceNames() {
            return this.names;
        }

        public void add(PropertySource<?> source) {
            if (source instanceof OriginTrackedMapPropertySource && !this.names.contains(source.getName())) {
                this.sources.addPropertySource(source);
                this.names.add(source.getName());
            }
        }

        @Override
        public Object getProperty(String name) {
            if (this.sources.containsProperty(name)) {
                return this.sources.getProperty(name);
            }
            return super.getProperty(name);
        }

        @Override
        public boolean containsProperty(String name) {
            if (this.sources.containsProperty(name)) {
                return true;
            }
            return super.containsProperty(name);
        }

        @Override
        public String[] getPropertyNames() {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(Arrays.asList(this.sources.getPropertyNames()));
            names.addAll(Arrays.asList(super.getPropertyNames()));
            return names.toArray(new String[0]);
        }

        @Override
        public Origin getOrigin(String name) {
            return this.sources.getOrigin(name);
        }
    }

    @Order(value=-2147483639)
    private static class DelegatingEnvironmentDecryptApplicationInitializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private ApplicationContextInitializer<ConfigurableApplicationContext> delegate;

        DelegatingEnvironmentDecryptApplicationInitializer(ApplicationContextInitializer<ConfigurableApplicationContext> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void initialize(ConfigurableApplicationContext applicationContext) {
            this.delegate.initialize(applicationContext);
        }
    }

    private static class AncestorInitializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext>,
    Ordered {
        private ConfigurableApplicationContext parent;

        AncestorInitializer(ConfigurableApplicationContext parent) {
            this.parent = parent;
        }

        public void setParent(ConfigurableApplicationContext parent) {
            this.parent = parent;
        }

        @Override
        public int getOrder() {
            return -2147483643;
        }

        @Override
        public void initialize(ConfigurableApplicationContext context) {
            while (context.getParent() != null && context.getParent() != context) {
                context = (ConfigurableApplicationContext)context.getParent();
            }
            this.reorderSources(context.getEnvironment());
            new ParentContextApplicationContextInitializer(this.parent).initialize(context);
        }

        private void reorderSources(ConfigurableEnvironment environment2) {
            PropertySource<?> removed = environment2.getPropertySources().remove(BootstrapApplicationListener.DEFAULT_PROPERTIES);
            if (removed instanceof ExtendedDefaultPropertySource) {
                ExtendedDefaultPropertySource defaultProperties = (ExtendedDefaultPropertySource)removed;
                environment2.getPropertySources().addLast(new MapPropertySource(BootstrapApplicationListener.DEFAULT_PROPERTIES, (Map)defaultProperties.getSource()));
                for (PropertySource<?> source : defaultProperties.getPropertySources().getPropertySources()) {
                    if (environment2.getPropertySources().contains(source.getName())) continue;
                    environment2.getPropertySources().addBefore(BootstrapApplicationListener.DEFAULT_PROPERTIES, source);
                }
            }
        }
    }

    private static class BootstrapMarkerConfiguration {
        private BootstrapMarkerConfiguration() {
        }
    }
}

