/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.config;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class BootstrapPropertySource<T>
extends EnumerablePropertySource<T> {
    private EnumerablePropertySource<T> delegate;

    public BootstrapPropertySource(EnumerablePropertySource<T> delegate) {
        super("bootstrapProperties-" + delegate.getName(), delegate.getSource());
        this.delegate = delegate;
    }

    @Override
    public Object getProperty(String name) {
        return this.delegate.getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        names.addAll(Arrays.asList(this.delegate.getPropertyNames()));
        return StringUtils.toStringArray(names);
    }

    public PropertySource<T> getDelegate() {
        return this.delegate;
    }
}

