/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public interface PropertySourceLocator {
    public PropertySource<?> locate(Environment var1);

    default public Collection<PropertySource<?>> locateCollection(Environment environment2) {
        return PropertySourceLocator.locateCollection(this, environment2);
    }

    public static Collection<PropertySource<?>> locateCollection(PropertySourceLocator locator, Environment environment2) {
        PropertySource<?> propertySource = locator.locate(environment2);
        if (propertySource == null) {
            return Collections.emptyList();
        }
        if (CompositePropertySource.class.isInstance(propertySource)) {
            Collection<PropertySource<?>> sources = ((CompositePropertySource)propertySource).getPropertySources();
            ArrayList filteredSources = new ArrayList();
            for (PropertySource<?> p : sources) {
                if (p == null) continue;
                filteredSources.add(p);
            }
            return filteredSources;
        }
        return Arrays.asList(propertySource);
    }
}

