/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.cloud.bootstrap.encrypt.AbstractEnvironmentDecrypt;
import org.springframework.cloud.bootstrap.encrypt.TextEncryptorUtils;
import org.springframework.cloud.util.PropertyUtils;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.util.ClassUtils;

public class DecryptEnvironmentPostProcessor
extends AbstractEnvironmentDecrypt
implements EnvironmentPostProcessor,
Ordered {
    private int order = Integer.MAX_VALUE;

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment2, SpringApplication application) {
        if (PropertyUtils.bootstrapEnabled(environment2) || PropertyUtils.useLegacyProcessing(environment2) || !this.isEnabled(environment2).booleanValue()) {
            return;
        }
        if (!ClassUtils.isPresent("org.springframework.security.crypto.encrypt.TextEncryptor", null)) {
            return;
        }
        MutablePropertySources propertySources = environment2.getPropertySources();
        environment2.getPropertySources().remove("decrypted");
        Map<String, Object> map = TextEncryptorUtils.decrypt(this, environment2, propertySources);
        if (!map.isEmpty()) {
            propertySources.addFirst(new SystemEnvironmentPropertySource("decrypted", map));
        }
    }

    protected Boolean isEnabled(ConfigurableEnvironment environment2) {
        return environment2.getProperty("spring.cloud.decrypt-environment-post-processor.enabled", Boolean.class, true);
    }
}

