/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bootstrap.encrypt;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.cloud.bootstrap.encrypt.AbstractEnvironmentDecrypt;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.util.PropertyUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public class EnvironmentDecryptApplicationInitializer
extends AbstractEnvironmentDecrypt
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    public static final String DECRYPTED_BOOTSTRAP_PROPERTY_SOURCE_NAME = "decryptedBootstrap";
    private int order = -2147483633;
    private TextEncryptor encryptor;

    public EnvironmentDecryptApplicationInitializer(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {
        ApplicationContext parent;
        Map<String, Object> map;
        PropertySource<?> bootstrap;
        ConfigurableEnvironment environment2 = applicationContext.getEnvironment();
        if (!PropertyUtils.bootstrapEnabled(environment2) && !PropertyUtils.useLegacyProcessing(environment2)) {
            return;
        }
        MutablePropertySources propertySources = environment2.getPropertySources();
        LinkedHashSet<String> found = new LinkedHashSet<String>();
        if (!propertySources.contains(DECRYPTED_BOOTSTRAP_PROPERTY_SOURCE_NAME) && (bootstrap = propertySources.get("bootstrap")) != null && !(map = this.decrypt(bootstrap)).isEmpty()) {
            found.addAll(map.keySet());
            this.insert(applicationContext, new SystemEnvironmentPropertySource(DECRYPTED_BOOTSTRAP_PROPERTY_SOURCE_NAME, map));
        }
        this.removeDecryptedProperties(applicationContext);
        Map<String, Object> map2 = this.decrypt(this.encryptor, propertySources);
        if (!map2.isEmpty()) {
            found.addAll(map2.keySet());
            this.insert(applicationContext, new SystemEnvironmentPropertySource("decrypted", map2));
        }
        if (!found.isEmpty() && (parent = applicationContext.getParent()) != null) {
            parent.publishEvent(new EnvironmentChangeEvent((Object)parent, found));
        }
    }

    private void insert(ApplicationContext applicationContext, PropertySource<?> propertySource) {
        for (ApplicationContext parent = applicationContext; parent != null; parent = parent.getParent()) {
            if (!(parent.getEnvironment() instanceof ConfigurableEnvironment)) continue;
            ConfigurableEnvironment mutable = (ConfigurableEnvironment)parent.getEnvironment();
            this.insert(mutable.getPropertySources(), propertySource);
        }
    }

    private void insert(MutablePropertySources propertySources, PropertySource<?> propertySource) {
        if (propertySources.contains("bootstrap")) {
            if (DECRYPTED_BOOTSTRAP_PROPERTY_SOURCE_NAME.equals(propertySource.getName())) {
                propertySources.addBefore("bootstrap", propertySource);
            } else {
                propertySources.addAfter("bootstrap", propertySource);
            }
        } else {
            propertySources.addFirst(propertySource);
        }
    }

    private void removeDecryptedProperties(ApplicationContext applicationContext) {
        for (ApplicationContext parent = applicationContext; parent != null; parent = parent.getParent()) {
            if (!(parent.getEnvironment() instanceof ConfigurableEnvironment)) continue;
            ((ConfigurableEnvironment)parent.getEnvironment()).getPropertySources().remove("decrypted");
        }
    }

    private Map<String, Object> decrypt(PropertySource<?> source) {
        Map<String, Object> properties = this.merge(source);
        this.decrypt(this.encryptor, properties);
        return properties;
    }

    private Map<String, Object> merge(PropertySource<?> source) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        this.merge(source, properties);
        return properties;
    }
}

