/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientRequest;

public class RequestData {
    private final HttpMethod httpMethod;
    private final URI url;
    private final HttpHeaders headers;
    private final MultiValueMap<String, String> cookies;
    private final Map<String, Object> attributes;

    public RequestData(HttpMethod httpMethod, URI url, HttpHeaders headers, MultiValueMap<String, String> cookies, Map<String, Object> attributes) {
        this.httpMethod = httpMethod;
        this.url = url;
        this.headers = headers;
        this.cookies = cookies;
        this.attributes = attributes;
    }

    public RequestData(ClientRequest request) {
        this(request.method(), request.url(), request.headers(), request.cookies(), request.attributes());
    }

    public RequestData(HttpRequest request) {
        this(request.getMethod(), request.getURI(), request.getHeaders(), RequestData.buildCookiesFromHeaders(request.getHeaders()), new HashMap<String, Object>());
    }

    public RequestData(ServerHttpRequest request) {
        this(request.getMethod(), request.getURI(), request.getHeaders(), RequestData.buildCookies(request.getCookies()), new HashMap<String, Object>());
    }

    public RequestData(ServerHttpRequest request, Map<String, Object> attributes) {
        this(request.getMethod(), request.getURI(), request.getHeaders(), RequestData.buildCookies(request.getCookies()), attributes);
    }

    private static MultiValueMap<String, String> buildCookies(MultiValueMap<String, HttpCookie> cookies) {
        HttpHeaders newCookies = new HttpHeaders();
        if (cookies != null) {
            cookies.forEach((key, value) -> value.forEach(cookie -> newCookies.put(cookie.getName(), Collections.singletonList(cookie.getValue()))));
        }
        return newCookies;
    }

    private static MultiValueMap<String, String> buildCookiesFromHeaders(HttpHeaders headers) {
        HttpHeaders newCookies = new HttpHeaders();
        if (headers == null) {
            return newCookies;
        }
        List cookiesFromHeaders = headers.get((Object)"Cookie");
        if (cookiesFromHeaders != null) {
            cookiesFromHeaders.forEach(cookie -> {
                String[] splitCookie = cookie.split("=");
                if (splitCookie.length < 2) {
                    return;
                }
                newCookies.put(splitCookie[0], Collections.singletonList(splitCookie[1]));
            });
        }
        return newCookies;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public URI getUrl() {
        return this.url;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public MultiValueMap<String, String> getCookies() {
        return this.cookies;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        ToStringCreator to = new ToStringCreator(this);
        to.append("httpMethod", this.httpMethod);
        to.append("url", this.url);
        to.append("headers", this.headers);
        to.append("cookies", this.cookies);
        return to.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestData)) {
            return false;
        }
        RequestData that = (RequestData)o;
        return this.httpMethod == that.httpMethod && Objects.equals(this.url, that.url) && Objects.equals(this.headers, that.headers) && Objects.equals(this.cookies, that.cookies) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.httpMethod, this.url, this.headers, this.cookies, this.attributes);
    }
}

