/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClientsProperties;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerClientRequestTransformer;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerRetryPolicy;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.client.loadbalancer.reactive.ReactorLoadBalancerExchangeFilterFunction;
import org.springframework.cloud.client.loadbalancer.reactive.RetryableExchangeFilterFunctionLoadBalancerRetryPolicy;
import org.springframework.cloud.client.loadbalancer.reactive.RetryableLoadBalancerExchangeFilterFunction;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={WebClient.class})
@ConditionalOnBean(value={ReactiveLoadBalancer.Factory.class})
@EnableConfigurationProperties(value={LoadBalancerClientsProperties.class})
public class ReactorLoadBalancerClientAutoConfiguration {
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.cloud.loadbalancer.retry.enabled"}, havingValue="false", matchIfMissing=true)
    @Bean
    public ReactorLoadBalancerExchangeFilterFunction loadBalancerExchangeFilterFunction(ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory, ObjectProvider<List<LoadBalancerClientRequestTransformer>> transformers) {
        return new ReactorLoadBalancerExchangeFilterFunction(loadBalancerFactory, transformers.getIfAvailable(Collections::emptyList));
    }

    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.cloud.loadbalancer.retry.enabled"}, havingValue="true")
    @Bean
    public RetryableLoadBalancerExchangeFilterFunction retryableLoadBalancerExchangeFilterFunction(ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory, LoadBalancerRetryPolicy.Factory retryPolicyFactory, ObjectProvider<List<LoadBalancerClientRequestTransformer>> transformers) {
        return new RetryableLoadBalancerExchangeFilterFunction(retryPolicyFactory, loadBalancerFactory, transformers.getIfAvailable(Collections::emptyList));
    }

    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"spring.cloud.loadbalancer.retry.enabled"}, havingValue="true")
    @Bean
    public LoadBalancerRetryPolicy.Factory loadBalancerRetryPolicy(ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory) {
        return new RetryableExchangeFilterFunctionLoadBalancerRetryPolicy.Factory(loadBalancerFactory);
    }
}

