/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.loadbalancer.reactive;

import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerProperties;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerRetryContext;
import org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerRetryPolicy;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.http.HttpMethod;

public class RetryableExchangeFilterFunctionLoadBalancerRetryPolicy
implements LoadBalancerRetryPolicy {
    private final LoadBalancerProperties properties;

    public RetryableExchangeFilterFunctionLoadBalancerRetryPolicy(LoadBalancerProperties properties) {
        this.properties = properties;
    }

    @Override
    public boolean canRetrySameServiceInstance(LoadBalancerRetryContext context) {
        return context.getRetriesSameServiceInstance() < this.properties.getRetry().getMaxRetriesOnSameServiceInstance();
    }

    @Override
    public boolean canRetryNextServiceInstance(LoadBalancerRetryContext context) {
        return context.getRetriesNextServiceInstance() < this.properties.getRetry().getMaxRetriesOnNextServiceInstance();
    }

    @Override
    public boolean retryableStatusCode(int statusCode) {
        return this.properties.getRetry().getRetryableStatusCodes().contains(statusCode);
    }

    @Override
    public boolean canRetryOnMethod(HttpMethod method) {
        return HttpMethod.GET.equals((Object)method) || this.properties.getRetry().isRetryOnAllOperations();
    }

    static class Factory
    implements LoadBalancerRetryPolicy.Factory {
        final ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory;

        Factory(ReactiveLoadBalancer.Factory<ServiceInstance> loadBalancerFactory) {
            this.loadBalancerFactory = loadBalancerFactory;
        }

        @Override
        public LoadBalancerRetryPolicy apply(String serviceId) {
            return new RetryableExchangeFilterFunctionLoadBalancerRetryPolicy(this.loadBalancerFactory.getProperties(serviceId));
        }
    }
}

