/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.util;

import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;

public final class IdUtils {
    private static final String SEPARATOR = ":";
    public static final String DEFAULT_SERVICE_ID_STRING = "${vcap.application.name:${spring.application.name:application}}:${vcap.application.instance_index:${spring.application.index:${local.server.port:${server.port:8080}}}}:${vcap.application.instance_id:${cachedrandom.${vcap.application.name:${spring.application.name:application}}.value}}";
    public static final String DEFAULT_SERVICE_ID_WITH_ACTIVE_PROFILES_STRING = "${vcap.application.name:${spring.application.name:application}:${spring.profiles.active}}:${vcap.application.instance_index:${spring.application.index:${local.server.port:${server.port:8080}}}}:${vcap.application.instance_id:${cachedrandom.${vcap.application.name:${spring.application.name:application}}.value}}";

    private IdUtils() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static String getDefaultInstanceId(PropertyResolver resolver) {
        return IdUtils.getDefaultInstanceId(resolver, true);
    }

    public static String getDefaultInstanceId(PropertyResolver resolver, boolean includeHostname) {
        String vcapInstanceId = resolver.getProperty("vcap.application.instance_id");
        if (StringUtils.hasText(vcapInstanceId)) {
            return vcapInstanceId;
        }
        String hostname = null;
        if (includeHostname) {
            hostname = resolver.getProperty("spring.cloud.client.hostname");
        }
        String appName = resolver.getProperty("spring.application.name");
        String namePart = IdUtils.combineParts(hostname, SEPARATOR, appName);
        String indexPart = resolver.getProperty("spring.application.instance_id", resolver.getProperty("server.port"));
        return IdUtils.combineParts(namePart, SEPARATOR, indexPart);
    }

    public static String getResolvedServiceId(PropertyResolver resolver) {
        String unresolvedServiceId = StringUtils.hasText(resolver.getProperty("spring.profiles.active")) ? IdUtils.getUnresolvedServiceIdWithActiveProfiles() : IdUtils.getUnresolvedServiceId();
        return resolver.resolvePlaceholders(unresolvedServiceId);
    }

    public static String getUnresolvedServiceId() {
        return DEFAULT_SERVICE_ID_STRING;
    }

    public static String getUnresolvedServiceIdWithActiveProfiles() {
        return DEFAULT_SERVICE_ID_WITH_ACTIVE_PROFILES_STRING;
    }

    public static String combineParts(String firstPart, String separator, String secondPart) {
        String combined = null;
        if (firstPart != null && secondPart != null) {
            combined = firstPart + separator + secondPart;
        } else if (firstPart != null) {
            combined = firstPart;
        } else if (secondPart != null) {
            combined = secondPart;
        }
        return combined;
    }
}

