/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.named;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.context.named.NamedContextFactory;
import org.springframework.lang.Nullable;

class ClientFactoryObjectProvider<T>
implements ObjectProvider<T> {
    private final NamedContextFactory<?> clientFactory;
    private final String name;
    private final Class<T> type;
    private ObjectProvider<T> provider;

    ClientFactoryObjectProvider(NamedContextFactory<?> clientFactory, String name, Class<T> type) {
        this.clientFactory = clientFactory;
        this.name = name;
        this.type = type;
    }

    @Override
    public T getObject(Object ... args) throws BeansException {
        return this.delegate().getObject(args);
    }

    @Override
    @Nullable
    public T getIfAvailable() throws BeansException {
        return this.delegate().getIfAvailable();
    }

    @Override
    public T getIfAvailable(Supplier<T> defaultSupplier) throws BeansException {
        return this.delegate().getIfAvailable(defaultSupplier);
    }

    @Override
    public void ifAvailable(Consumer<T> dependencyConsumer) throws BeansException {
        this.delegate().ifAvailable(dependencyConsumer);
    }

    @Override
    @Nullable
    public T getIfUnique() throws BeansException {
        return this.delegate().getIfUnique();
    }

    @Override
    public T getIfUnique(Supplier<T> defaultSupplier) throws BeansException {
        return this.delegate().getIfUnique(defaultSupplier);
    }

    @Override
    public void ifUnique(Consumer<T> dependencyConsumer) throws BeansException {
        this.delegate().ifUnique(dependencyConsumer);
    }

    @Override
    public Iterator<T> iterator() {
        return this.delegate().iterator();
    }

    @Override
    public Stream<T> stream() {
        return this.delegate().stream();
    }

    @Override
    public T getObject() throws BeansException {
        return this.delegate().getObject();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.delegate().forEach(action);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.delegate().spliterator();
    }

    private ObjectProvider<T> delegate() {
        if (this.provider == null) {
            this.provider = this.clientFactory.getProvider(this.name, this.type);
        }
        return this.provider;
    }
}

