/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.refresh;

import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.DefaultBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.boot.util.Instantiator;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.support.SpringFactoriesLoader;

public class ConfigDataContextRefresher
extends ContextRefresher
implements ApplicationListener<ApplicationPreparedEvent> {
    private SpringApplication application;

    @Deprecated
    public ConfigDataContextRefresher(ConfigurableApplicationContext context, RefreshScope scope) {
        super(context, scope);
    }

    public ConfigDataContextRefresher(ConfigurableApplicationContext context, RefreshScope scope, RefreshAutoConfiguration.RefreshProperties properties) {
        super(context, scope, properties);
    }

    @Override
    public void onApplicationEvent(ApplicationPreparedEvent event) {
        this.application = event.getSpringApplication();
    }

    @Override
    protected void updateEnvironment() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Re-processing environment to add config data");
        }
        StandardEnvironment environment2 = this.copyEnvironment(this.getContext().getEnvironment());
        ConfigurableBootstrapContext bootstrapContext = this.getContext().getBeanProvider(ConfigurableBootstrapContext.class).getIfAvailable(DefaultBootstrapContext::new);
        PassthruDeferredLogFactory logFactory = new PassthruDeferredLogFactory();
        List<String> classNames = SpringFactoriesLoader.loadFactoryNames(EnvironmentPostProcessor.class, this.getClass().getClassLoader());
        Instantiator instantiator = new Instantiator(EnvironmentPostProcessor.class, parameters -> {
            parameters.add(DeferredLogFactory.class, logFactory);
            parameters.add(Log.class, logFactory::getLog);
            parameters.add(ConfigurableBootstrapContext.class, bootstrapContext);
            parameters.add(BootstrapContext.class, bootstrapContext);
            parameters.add(BootstrapRegistry.class, bootstrapContext);
        });
        List postProcessors = instantiator.instantiate(classNames);
        for (EnvironmentPostProcessor postProcessor : postProcessors) {
            postProcessor.postProcessEnvironment(environment2, this.application);
        }
        if (environment2.getPropertySources().contains("refreshArgs")) {
            environment2.getPropertySources().remove("refreshArgs");
        }
        MutablePropertySources target = this.getContext().getEnvironment().getPropertySources();
        String targetName = null;
        for (PropertySource<?> source : environment2.getPropertySources()) {
            String name = source.getName();
            if (target.contains(name)) {
                targetName = name;
            }
            if (this.standardSources.contains(name)) continue;
            if (target.contains(name)) {
                target.replace(name, source);
                continue;
            }
            if (targetName != null) {
                target.addAfter(targetName, source);
                targetName = name;
                continue;
            }
            target.addFirst(source);
            targetName = name;
        }
    }

    static class PassthruDeferredLogFactory
    implements DeferredLogFactory {
        PassthruDeferredLogFactory() {
        }

        @Override
        public Log getLog(Supplier<Log> destination) {
            return destination.get();
        }

        @Override
        public Log getLog(Class<?> destination) {
            return this.getLog(() -> LogFactory.getLog(destination));
        }

        @Override
        public Log getLog(Log destination) {
            return this.getLog(() -> destination);
        }
    }
}

