/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.logging;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class LoggingRebinder
implements ApplicationListener<EnvironmentChangeEvent>,
EnvironmentAware {
    private static final Bindable<Map<String, String>> STRING_STRING_MAP = Bindable.mapOf(String.class, String.class);
    private final Log logger = LogFactory.getLog(this.getClass());
    private Environment environment;

    @Override
    public void setEnvironment(Environment environment2) {
        this.environment = environment2;
    }

    @Override
    public void onApplicationEvent(EnvironmentChangeEvent event) {
        if (this.environment == null) {
            return;
        }
        LoggingSystem system = LoggingSystem.get(LoggingSystem.class.getClassLoader());
        this.setLogLevels(system, this.environment);
    }

    protected void setLogLevels(LoggingSystem system, Environment environment2) {
        Map levels = Binder.get(environment2).bind("logging.level", STRING_STRING_MAP).orElseGet(Collections::emptyMap);
        for (Map.Entry entry : levels.entrySet()) {
            this.setLogLevel(system, environment2, (String)entry.getKey(), ((String)entry.getValue()).toString());
        }
    }

    private void setLogLevel(LoggingSystem system, Environment environment2, String name, String level) {
        try {
            if (name.equalsIgnoreCase("root")) {
                name = null;
            }
            level = environment2.resolvePlaceholders(level);
            system.setLogLevel(name, this.resolveLogLevel(level));
        }
        catch (RuntimeException ex) {
            this.logger.error("Cannot set level: " + level + " for '" + name + "'");
        }
    }

    private LogLevel resolveLogLevel(String level) {
        String trimmedLevel = level.trim();
        if ("false".equalsIgnoreCase(trimmedLevel)) {
            return LogLevel.OFF;
        }
        return LogLevel.valueOf(trimmedLevel.toUpperCase(Locale.ENGLISH));
    }
}

