/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.util.random;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class CachedRandomPropertySource
extends PropertySource<PropertySource> {
    static final String NAME = "cachedrandom";
    private static final String PREFIX = "cachedrandom.";
    private static Map<String, Map<String, Object>> cache = new ConcurrentHashMap<String, Map<String, Object>>();

    public CachedRandomPropertySource(PropertySource randomValuePropertySource) {
        super(NAME, randomValuePropertySource);
    }

    CachedRandomPropertySource(PropertySource randomValuePropertySource, Map<String, Map<String, Object>> cache) {
        super(NAME, randomValuePropertySource);
        CachedRandomPropertySource.cache = cache;
    }

    @Override
    public Object getProperty(String name) {
        String keyAndType;
        int lastIndexOfDot;
        if (!name.startsWith(PREFIX) || name.length() == PREFIX.length()) {
            return null;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Generating random property for '" + name + "'");
        }
        if ((lastIndexOfDot = (keyAndType = name.substring(PREFIX.length())).lastIndexOf(".")) < 0) {
            return null;
        }
        String key = keyAndType.substring(0, lastIndexOfDot);
        String type = keyAndType.substring(lastIndexOfDot + 1);
        if (StringUtils.hasText(key) && StringUtils.hasText(type)) {
            return this.getRandom(type, key);
        }
        return null;
    }

    private Object getRandom(String type, String key) {
        Map<String, Object> randomValueCache = this.getCacheForKey(key);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking in random cache for key " + key + " with type " + type);
        }
        return randomValueCache.computeIfAbsent(type, theType -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(String.format("No random value found in cache for key: %s and type: %s, generating a new value", key, type));
            }
            return ((PropertySource)this.getSource()).getProperty("random." + type);
        });
    }

    private Map<String, Object> getCacheForKey(String key) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Looking in random cache for key: " + key);
        }
        return cache.computeIfAbsent(key, theKey -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No cached value found for key: " + key);
            }
            return new ConcurrentHashMap();
        });
    }

    public static void clearCache() {
        if (cache != null) {
            cache.clear();
        }
    }
}

