/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.piscesplatform.controller;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.piscesplatform.model.bo.AbilityInterfaceTaskReqBo;
import com.ohaotian.piscesplatform.model.bo.AbilityTaskStatusChangeBo;
import com.ohaotian.piscesplatform.model.bo.InsertTaskReqBo;
import com.ohaotian.piscesplatform.model.bo.QueryAbilityReqBo;
import com.ohaotian.piscesplatform.service.AbilityInterfaceTaskService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.portalcommon.model.bo.RspBO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/interfaceTask"})
public class AbilityInterfaceTaskController {
    @Autowired
    private AbilityInterfaceTaskService abilityInterfaceTaskService;

    @PostMapping(value={"/queryByTaskId"})
    @BusiResponseBody
    public RspBO queryByTaskId(@RequestBody JSONObject jsonObject) {
        if (ObjectUtils.isEmpty((Object)jsonObject.getLong("taskId"))) {
            throw new ZTBusinessException("\u6ca1\u6709\u6307\u5b9a\u4efb\u52a1id");
        }
        return this.abilityInterfaceTaskService.queryByTaskId(jsonObject.getLong("taskId"));
    }

    @PostMapping(value={"/queryTaskList"})
    @BusiResponseBody
    public RspBO queryTaskList(@RequestBody AbilityInterfaceTaskReqBo abilityInterfaceTaskReqBo) {
        return this.abilityInterfaceTaskService.queryByCond(abilityInterfaceTaskReqBo);
    }

    @PostMapping(value={"/addTask"})
    @BusiResponseBody
    public RspBO addTask(@RequestBody InsertTaskReqBo insertTaskReqBo) {
        if (Boolean.FALSE.equals(StringUtils.isNotBlank((CharSequence)insertTaskReqBo.getTaskName()))) {
            throw new ZTBusinessException("\u7f3a\u5c11\u4efb\u52a1\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (insertTaskReqBo.getAbilityId() == null) {
            throw new ZTBusinessException("\u7f3a\u5c11\u4e3b\u80fd\u529b\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (Boolean.FALSE.equals(StringUtils.isNotBlank((CharSequence)insertTaskReqBo.getTaskVersionInfo().getVersion()))) {
            throw new ZTBusinessException("\u7f3a\u5c11\u7248\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        return this.abilityInterfaceTaskService.insert(insertTaskReqBo);
    }

    @PostMapping(value={"/update"})
    @BusiResponseBody
    public RspBO update(@RequestBody InsertTaskReqBo insertTaskReqBo) {
        if (Boolean.FALSE.equals(StringUtils.isNotBlank((CharSequence)insertTaskReqBo.getTaskVersionInfo().getVersion()))) {
            throw new ZTBusinessException("\u7f3a\u5c11\u7248\u672c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        return this.abilityInterfaceTaskService.update(insertTaskReqBo);
    }

    @PostMapping(value={"/deleteByTaskId"})
    @BusiResponseBody
    public RspBO deleteByTaskId(@RequestBody JSONObject jsonObject) {
        return this.abilityInterfaceTaskService.deleteByTaskId(jsonObject.getLong("taskId"));
    }

    @PostMapping(value={"/queryAbilityList"})
    @BusiResponseBody
    public RspBO queryAbilityList(@RequestBody QueryAbilityReqBo queryAbilityReqBo) {
        return this.abilityInterfaceTaskService.queryAbilityList(queryAbilityReqBo);
    }

    @PostMapping(value={"/changeTaskStatus"})
    @BusiResponseBody
    public RspBO changeTaskStatus(@RequestBody AbilityTaskStatusChangeBo abilityTaskStatusChangeBo) {
        return this.abilityInterfaceTaskService.changeTaskStatus(abilityTaskStatusChangeBo);
    }

    @PostMapping(value={"/getSimpleMethods"})
    @BusiResponseBody
    public RspBO getSimpleMethods() {
        return this.abilityInterfaceTaskService.getSimpleMethods();
    }

    @PostMapping(value={"/getTags"})
    @BusiResponseBody
    public RspBO getTags() {
        return this.abilityInterfaceTaskService.getTags();
    }

    @PostMapping(value={"/getMethods"})
    @BusiResponseBody
    public RspBO getMethods() {
        return this.abilityInterfaceTaskService.getMethods();
    }

    @PostMapping(value={"/getMethodTemplate"})
    @BusiResponseBody
    public RspBO getMethodTemplate(@RequestBody JSONObject jsonObject) {
        return this.abilityInterfaceTaskService.getMethodTemplate(jsonObject.getString("method"));
    }
}

