/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.piscesplatform.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.piscesplatform.mapper.AbilityInterfaceTaskMapper;
import com.ohaotian.piscesplatform.mapper.AbilityInterfaceTaskVersionBindMapper;
import com.ohaotian.piscesplatform.mapper.AbilityInterfaceTaskVersionMapper;
import com.ohaotian.piscesplatform.model.bo.AbilityInterfaceTaskReqBo;
import com.ohaotian.piscesplatform.model.bo.AbilityInterfaceTaskRspBo;
import com.ohaotian.piscesplatform.model.bo.AbilityInterfaceTaskVersionReqBo;
import com.ohaotian.piscesplatform.model.bo.AbilityTaskStatusChangeBo;
import com.ohaotian.piscesplatform.model.bo.EnumRspBo;
import com.ohaotian.piscesplatform.model.bo.InsertTaskReqBo;
import com.ohaotian.piscesplatform.model.bo.QueryAbilityReqBo;
import com.ohaotian.piscesplatform.model.bo.QueryAbilityRspBo;
import com.ohaotian.piscesplatform.model.po.AbilityInterfaceTaskPo;
import com.ohaotian.piscesplatform.model.po.AbilityInterfaceTaskVersionBindPo;
import com.ohaotian.piscesplatform.model.po.AbilityInterfaceTaskVersionPo;
import com.ohaotian.piscesplatform.service.AbilityInterfaceTaskService;
import com.ohaotian.piscesplatform.util.RuleToXmlUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.model.baseEnum.BaseMethods;
import com.ohaotian.plugin.model.baseEnum.BaseTags;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class AbilityInterfaceTaskServiceImpl
implements AbilityInterfaceTaskService {
    @Resource
    private AbilityInterfaceTaskMapper abilityInterfaceTaskMapper;
    @Resource
    private AbilityInterfaceTaskVersionMapper abilityInterfaceTaskVersionMapper;
    @Resource
    private AbilityInterfaceTaskVersionBindMapper abilityInterfaceTaskVersionBindMapper;

    @Override
    public RspBO<InsertTaskReqBo> queryByTaskId(Long taskId) {
        AbilityInterfaceTaskPo abilityInterfaceTaskPo = new AbilityInterfaceTaskPo();
        abilityInterfaceTaskPo.setTaskId(taskId);
        AbilityInterfaceTaskPo taskPo = this.abilityInterfaceTaskMapper.queryByTaskInfo(abilityInterfaceTaskPo);
        InsertTaskReqBo taskRspBo = (InsertTaskReqBo)BeanMapper.map((Object)taskPo, InsertTaskReqBo.class);
        AbilityInterfaceTaskVersionPo taskVersionPo = new AbilityInterfaceTaskVersionPo();
        taskVersionPo.setTaskId(taskId);
        taskVersionPo.setStatus(1);
        AbilityInterfaceTaskVersionPo queryByTaskVersionInfo = this.abilityInterfaceTaskVersionMapper.queryByTaskVersionInfo(taskVersionPo);
        taskRspBo.setTaskVersionInfo((AbilityInterfaceTaskVersionReqBo)BeanMapper.map((Object)queryByTaskVersionInfo, AbilityInterfaceTaskVersionReqBo.class));
        AbilityInterfaceTaskVersionBindPo taskVersionBindPo = new AbilityInterfaceTaskVersionBindPo();
        taskVersionBindPo.setTaskVersionId(queryByTaskVersionInfo.getTaskVersionId());
        List<AbilityInterfaceTaskVersionBindPo> taskVersionBindPoList = this.abilityInterfaceTaskVersionBindMapper.queryByCond(taskVersionBindPo);
        List<Long> abilityList = taskVersionBindPoList.stream().map(AbilityInterfaceTaskVersionBindPo::getAbilityId).collect(Collectors.toList());
        taskRspBo.getTaskVersionInfo().setAbilityIdList(abilityList);
        return RspBO.success((Object)taskRspBo);
    }

    @Override
    public RspBO<RspPage<List<AbilityInterfaceTaskRspBo>>> queryByCond(AbilityInterfaceTaskReqBo abilityInterfaceTaskReqBo) {
        Page page = PageMethod.startPage((int)abilityInterfaceTaskReqBo.getPageNo(), (int)abilityInterfaceTaskReqBo.getPageSize());
        List<AbilityInterfaceTaskRspBo> abilityInterfaceTaskRspBoList = this.getTaskRspBo(abilityInterfaceTaskReqBo);
        RspPage rspPage = new RspPage(Integer.valueOf(abilityInterfaceTaskReqBo.getPageSize()), Integer.valueOf(abilityInterfaceTaskReqBo.getPageNo()), abilityInterfaceTaskRspBoList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    public List<AbilityInterfaceTaskRspBo> getTaskRspBo(AbilityInterfaceTaskReqBo abilityInterfaceTaskReqBo) {
        List<AbilityInterfaceTaskRspBo> abilityInterfaceTaskRspBoList = this.abilityInterfaceTaskMapper.queryByCond(abilityInterfaceTaskReqBo);
        Iterator<AbilityInterfaceTaskRspBo> it = abilityInterfaceTaskRspBoList.iterator();
        if (ObjectUtils.isEmpty((Object)abilityInterfaceTaskReqBo.getTransStatus())) {
            while (it.hasNext()) {
                AbilityInterfaceTaskRspBo rspBo = it.next();
                if (rspBo.getReqTransStatus() != null && rspBo.getReqTransStatus() == 3) {
                    rspBo.setReqTransStatus(1);
                } else {
                    rspBo.setReqTransStatus(0);
                }
                if (rspBo.getRspTransStatus() != null && rspBo.getRspTransStatus() == 3) {
                    rspBo.setRspTransStatus(1);
                    continue;
                }
                rspBo.setRspTransStatus(0);
            }
        } else if (abilityInterfaceTaskReqBo.getTransStatus() == 0) {
            while (it.hasNext()) {
                AbilityInterfaceTaskRspBo rspBo = it.next();
                if (rspBo.getReqTransStatus() != null && rspBo.getReqTransStatus() == 3 || rspBo.getRspTransStatus() != null && rspBo.getRspTransStatus() == 3) {
                    it.remove();
                    continue;
                }
                rspBo.setReqTransStatus(0);
                rspBo.setRspTransStatus(0);
            }
        } else if (abilityInterfaceTaskReqBo.getTransStatus() == 1) {
            while (it.hasNext()) {
                AbilityInterfaceTaskRspBo rspBo = it.next();
                if (rspBo.getReqTransStatus() != null && rspBo.getReqTransStatus() == 3 || rspBo.getRspTransStatus() != null && rspBo.getRspTransStatus() == 3) {
                    if (rspBo.getReqTransStatus() == null || rspBo.getReqTransStatus() != 3) {
                        rspBo.setReqTransStatus(0);
                        rspBo.setRspTransStatus(1);
                        continue;
                    }
                    rspBo.setReqTransStatus(1);
                    if (rspBo.getRspTransStatus() != null && rspBo.getRspTransStatus() == 3) {
                        rspBo.setRspTransStatus(1);
                        continue;
                    }
                    rspBo.setRspTransStatus(0);
                    continue;
                }
                it.remove();
            }
        } else {
            throw new ZTBusinessException("\u67e5\u8be2\u53c2\u6570\u51fa\u9519");
        }
        return abilityInterfaceTaskRspBoList;
    }

    @Override
    @Transactional
    public RspBO<String> insert(InsertTaskReqBo insertTaskReqBo) {
        AbilityInterfaceTaskPo qryPo = new AbilityInterfaceTaskPo();
        qryPo.setAbilityId(insertTaskReqBo.getAbilityId());
        AbilityInterfaceTaskPo qryResultPo = this.abilityInterfaceTaskMapper.queryByTaskInfo(qryPo);
        if (Boolean.FALSE.equals(ObjectUtils.isEmpty((Object)qryResultPo))) {
            throw new ZTBusinessException("\u8be5\u4e3b\u80fd\u529b\u5df2\u7ecf\u5b58\u5728\u4efb\u52a1\u4e86\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u65b0\u5efa\uff01");
        }
        Long userId = Long.valueOf(UserHolder.getUserId());
        Date date = new Date();
        AbilityInterfaceTaskPo abilityInterfaceTaskPo = (AbilityInterfaceTaskPo)BeanMapper.map((Object)insertTaskReqBo, AbilityInterfaceTaskPo.class);
        abilityInterfaceTaskPo.setCreateUserId(userId);
        abilityInterfaceTaskPo.setCreateTime(date);
        this.abilityInterfaceTaskMapper.insert(abilityInterfaceTaskPo);
        Long taskId = this.abilityInterfaceTaskMapper.queryByTaskInfo(abilityInterfaceTaskPo).getTaskId();
        insertTaskReqBo.getTaskVersionInfo().setTaskId(taskId);
        AbilityInterfaceTaskVersionPo abilityInterfaceTaskVersionPo = (AbilityInterfaceTaskVersionPo)BeanMapper.map((Object)insertTaskReqBo.getTaskVersionInfo(), AbilityInterfaceTaskVersionPo.class);
        abilityInterfaceTaskVersionPo.setStatus(1);
        abilityInterfaceTaskVersionPo.setCreateUserId(userId);
        abilityInterfaceTaskVersionPo.setCreateTime(date);
        abilityInterfaceTaskVersionPo.setUpdateUserId(userId);
        abilityInterfaceTaskVersionPo.setUpdateTime(date);
        abilityInterfaceTaskVersionPo.setReqXmlLogic(RuleToXmlUtil.ruleToXmlUtil(abilityInterfaceTaskVersionPo.getReqDocxData(), abilityInterfaceTaskVersionPo.getReqTransRule()));
        abilityInterfaceTaskVersionPo.setRspXmlLogic(RuleToXmlUtil.ruleToXmlUtil(abilityInterfaceTaskVersionPo.getRspDocxData(), abilityInterfaceTaskVersionPo.getRspTransRule()));
        this.abilityInterfaceTaskVersionMapper.insert(abilityInterfaceTaskVersionPo);
        insertTaskReqBo.getTaskVersionInfo().setTaskVersionId(this.abilityInterfaceTaskVersionMapper.queryByTaskVersionInfo(abilityInterfaceTaskVersionPo).getTaskVersionId());
        this.insertTaskVersionBind(insertTaskReqBo.getTaskVersionInfo());
        return RspBO.success((Object)("\u63d2\u5165 " + abilityInterfaceTaskPo.getTaskName() + " \u4efb\u52a1 " + abilityInterfaceTaskVersionPo.getVersion() + " \u7248\u672c\u6210\u529f"));
    }

    @Override
    @Transactional
    public RspBO<String> update(InsertTaskReqBo insertTaskReqBo) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        Date date = new Date();
        AbilityInterfaceTaskPo abilityInterfaceTaskPo = (AbilityInterfaceTaskPo)BeanMapper.map((Object)insertTaskReqBo, AbilityInterfaceTaskPo.class);
        abilityInterfaceTaskPo.setUpdateUserId(userId);
        abilityInterfaceTaskPo.setUpdateTime(date);
        this.abilityInterfaceTaskMapper.update(abilityInterfaceTaskPo);
        AbilityInterfaceTaskVersionPo qryTaskVersionPo = new AbilityInterfaceTaskVersionPo();
        qryTaskVersionPo.setTaskId(abilityInterfaceTaskPo.getTaskId());
        qryTaskVersionPo.setVersion(insertTaskReqBo.getTaskVersionInfo().getVersion());
        AbilityInterfaceTaskVersionPo taskVersionPo = this.abilityInterfaceTaskVersionMapper.queryByTaskVersionInfo(qryTaskVersionPo);
        AbilityInterfaceTaskVersionPo abilityInterfaceTaskVersionPo = (AbilityInterfaceTaskVersionPo)BeanMapper.map((Object)insertTaskReqBo.getTaskVersionInfo(), AbilityInterfaceTaskVersionPo.class);
        abilityInterfaceTaskVersionPo.setTaskId(insertTaskReqBo.getTaskId());
        abilityInterfaceTaskVersionPo.setReqXmlLogic(RuleToXmlUtil.ruleToXmlUtil(abilityInterfaceTaskVersionPo.getReqDocxData(), abilityInterfaceTaskVersionPo.getReqTransRule()));
        abilityInterfaceTaskVersionPo.setRspXmlLogic(RuleToXmlUtil.ruleToXmlUtil(abilityInterfaceTaskVersionPo.getRspDocxData(), abilityInterfaceTaskVersionPo.getRspTransRule()));
        abilityInterfaceTaskVersionPo.setUpdateUserId(userId);
        abilityInterfaceTaskVersionPo.setUpdateTime(date);
        if (insertTaskReqBo.getCreateFlag() == 0) {
            if (ObjectUtils.isEmpty((Object)taskVersionPo)) {
                throw new ZTBusinessException("\u66f4\u65b0\u5931\u8d25\uff0c\u5f53\u524d\u7248\u672c" + insertTaskReqBo.getTaskVersionInfo().getVersion() + "\u4e0d\u5b58\u5728\uff01");
            }
            abilityInterfaceTaskVersionPo.setTaskVersionId(taskVersionPo.getTaskVersionId());
            insertTaskReqBo.getTaskVersionInfo().setTaskVersionId(taskVersionPo.getTaskVersionId());
            abilityInterfaceTaskVersionPo.setStatus(null);
            this.abilityInterfaceTaskVersionMapper.update(abilityInterfaceTaskVersionPo);
            this.abilityInterfaceTaskVersionBindMapper.deleteByTaskVersionId(abilityInterfaceTaskVersionPo.getTaskVersionId());
            this.insertTaskVersionBind(insertTaskReqBo.getTaskVersionInfo());
        } else {
            if (Boolean.FALSE.equals(ObjectUtils.isEmpty((Object)taskVersionPo))) {
                throw new ZTBusinessException("\u65b0\u589e\u7684\u7248\u672c\u53f7\u5df2\u7ecf\u5b58\u5728\uff01\uff01\uff01");
            }
            abilityInterfaceTaskVersionPo.setTaskVersionId(null);
            abilityInterfaceTaskVersionPo.setStatus(0);
            abilityInterfaceTaskVersionPo.setCreateUserId(userId);
            abilityInterfaceTaskVersionPo.setCreateTime(date);
            this.abilityInterfaceTaskVersionMapper.insert(abilityInterfaceTaskVersionPo);
            insertTaskReqBo.getTaskVersionInfo().setTaskVersionId(this.abilityInterfaceTaskVersionMapper.queryByTaskVersionInfo(abilityInterfaceTaskVersionPo).getTaskVersionId());
            this.insertTaskVersionBind(insertTaskReqBo.getTaskVersionInfo());
        }
        return RspBO.success((Object)"\u66f4\u65b0\u6570\u636e\u6210\u529f!");
    }

    public void insertTaskVersionBind(AbilityInterfaceTaskVersionReqBo taskVersionInfo) {
        List<AbilityInterfaceTaskVersionBindPo> abilityInterfaceTaskVersionBindPoList = taskVersionInfo.getAbilityIdList().stream().map(abilityId -> {
            AbilityInterfaceTaskVersionBindPo abilityTaskVersionBindPo = new AbilityInterfaceTaskVersionBindPo();
            abilityTaskVersionBindPo.setAbilityId((Long)abilityId);
            abilityTaskVersionBindPo.setTaskVersionId(taskVersionInfo.getTaskVersionId());
            return abilityTaskVersionBindPo;
        }).collect(Collectors.toList());
        if (Boolean.FALSE.equals(abilityInterfaceTaskVersionBindPoList.isEmpty())) {
            this.abilityInterfaceTaskVersionBindMapper.insertList(abilityInterfaceTaskVersionBindPoList);
        }
    }

    @Override
    @Transactional
    public RspBO<String> deleteByTaskId(Long taskId) {
        AbilityInterfaceTaskReqBo checkReqTaskBo = new AbilityInterfaceTaskReqBo();
        checkReqTaskBo.setTaskId(taskId);
        List<AbilityInterfaceTaskRspBo> checkRspBo = this.getTaskRspBo(checkReqTaskBo);
        AbilityInterfaceTaskRspBo abilityInterfaceTaskRspBo = checkRspBo.get(0);
        if (abilityInterfaceTaskRspBo.getReqTransStatus() != 0 || abilityInterfaceTaskRspBo.getRspTransStatus() != 0) {
            throw new ZTBusinessException("\u8be5\u4efb\u52a1\u7684\u72b6\u6001\u4e0d\u4e3a\u5747\u505c\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        List<AbilityInterfaceTaskVersionPo> abilityInterfaceTaskVersionPoList = this.abilityInterfaceTaskVersionMapper.queryByCond(taskId);
        List<Long> taskVersionIdList = abilityInterfaceTaskVersionPoList.stream().map(AbilityInterfaceTaskVersionPo::getTaskVersionId).collect(Collectors.toList());
        int abilityCount = 0;
        if (Boolean.FALSE.equals(taskVersionIdList.isEmpty())) {
            abilityCount = this.abilityInterfaceTaskVersionBindMapper.deleteByTaskVersionIdList(taskVersionIdList);
        }
        int versionCount = this.abilityInterfaceTaskVersionMapper.deleteByTaskId(taskId);
        this.abilityInterfaceTaskMapper.deleteByTaskId(taskId);
        return RspBO.success((Object)("\u5220\u9664\u4efb\u52a1\u6210\u529f\uff0c\u5171\u5220\u9664" + versionCount + "\u4e2a\u7248\u672c\uff0c\u5171" + abilityCount + "\u4e2a\u5b50\u80fd\u529b\uff01"));
    }

    @Override
    public RspBO<RspPage<List<QueryAbilityRspBo>>> queryAbilityList(QueryAbilityReqBo queryAbilityReqBo) {
        Page page = PageMethod.startPage((int)queryAbilityReqBo.getPageNo(), (int)queryAbilityReqBo.getPageSize());
        List<QueryAbilityRspBo> queryAbilityRspBoList = this.abilityInterfaceTaskMapper.queryAbilityList(queryAbilityReqBo);
        RspPage rspPage = new RspPage(Integer.valueOf(queryAbilityReqBo.getPageSize()), Integer.valueOf(queryAbilityReqBo.getPageNo()), queryAbilityRspBoList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    @Transactional
    public RspBO<String> changeTaskStatus(AbilityTaskStatusChangeBo abilityTaskStatusChangeBo) {
        if (ObjectUtils.isEmpty((Object)abilityTaskStatusChangeBo.getAbilityId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u80fd\u529bId\uff01");
        }
        if (ObjectUtils.isEmpty((Object)abilityTaskStatusChangeBo.getReqTransStatus()) || ObjectUtils.isEmpty((Object)abilityTaskStatusChangeBo.getRspTransStatus())) {
            throw new ZTBusinessException("\u72b6\u6001\u53c2\u6570\u4e0d\u5b8c\u6574\uff01");
        }
        AbilityInterfaceTaskVersionPo abilityInterfaceTaskVersionPo = new AbilityInterfaceTaskVersionPo();
        abilityInterfaceTaskVersionPo.setTaskId(abilityTaskStatusChangeBo.getTaskId());
        abilityInterfaceTaskVersionPo.setStatus(1);
        AbilityInterfaceTaskVersionPo taskVersionInfo = this.abilityInterfaceTaskVersionMapper.queryByTaskVersionInfo(abilityInterfaceTaskVersionPo);
        if (abilityTaskStatusChangeBo.getReqTransStatus() == 1) {
            abilityTaskStatusChangeBo.setReqTransStatus(3);
            abilityTaskStatusChangeBo.setReqXml(taskVersionInfo.getReqXmlLogic());
        } else if (abilityTaskStatusChangeBo.getReqTransStatus() != 0) {
            throw new ZTBusinessException("\u72b6\u6001\u53c2\u6570\u9519\u8bef!");
        }
        if (abilityTaskStatusChangeBo.getRspTransStatus() == 1) {
            abilityTaskStatusChangeBo.setRspTransStatus(3);
            abilityTaskStatusChangeBo.setRspXml(taskVersionInfo.getRspXmlLogic());
        } else if (abilityTaskStatusChangeBo.getRspTransStatus() != 0) {
            throw new ZTBusinessException("\u72b6\u6001\u53c2\u6570\u9519\u8bef!");
        }
        JSONObject jsonObject = this.abilityInterfaceTaskMapper.qryTransInfoByAbilityId(abilityTaskStatusChangeBo.getAbilityId());
        if (ObjectUtils.isEmpty((Object)jsonObject)) {
            this.abilityInterfaceTaskMapper.insertTransInfo(abilityTaskStatusChangeBo);
        } else {
            this.abilityInterfaceTaskMapper.changeTaskStatus(abilityTaskStatusChangeBo);
        }
        return RspBO.success((Object)"\u4fee\u6539\u72b6\u6001\u6210\u529f!");
    }

    @Override
    public RspBO<List<EnumRspBo>> getSimpleMethods() {
        ArrayList<EnumRspBo> enumRspBoList = new ArrayList<EnumRspBo>();
        for (BaseMethods baseMethod : EnumSet.allOf(BaseMethods.class)) {
            if (!this.isSimpleMethod(baseMethod)) continue;
            enumRspBoList.add(EnumRspBo.builder().value(baseMethod.getCode()).label(baseMethod.getLabel()).build());
        }
        return RspBO.success(enumRspBoList);
    }

    public boolean isSimpleMethod(BaseMethods baseMethod) {
        return false;
    }

    @Override
    public RspBO<List<EnumRspBo>> getTags() {
        ArrayList<EnumRspBo> enumRspBoList = new ArrayList<EnumRspBo>();
        for (BaseTags baseTags : EnumSet.allOf(BaseTags.class)) {
            if (baseTags.equals((Object)BaseTags.TAG_INTERFACE)) continue;
            enumRspBoList.add(EnumRspBo.builder().value(baseTags.getTemplate()).label(baseTags.getCode()).build());
        }
        return RspBO.success(enumRspBoList);
    }

    @Override
    public RspBO<List<EnumRspBo>> getMethods() {
        ArrayList<EnumRspBo> enumRspBoList = new ArrayList<EnumRspBo>();
        for (BaseMethods baseMethods : EnumSet.allOf(BaseMethods.class)) {
            enumRspBoList.add(EnumRspBo.builder().value(baseMethods.getCode()).label(baseMethods.getLabel()).build());
        }
        return RspBO.success(enumRspBoList);
    }

    @Override
    public RspBO<String> getMethodTemplate(String method) {
        return RspBO.success((Object)BaseMethods.getWithCode((String)method).getTemplate());
    }
}

