package com.ohaotian.plugin.mq.proxy.constants;

import org.slf4j.Logger;

/**
 * 标题：日志工具类
 * <p>
 * 说明：日志工具类
 * <br>
 * 时间：2018/07/25<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author ZhangCheng
 */
public class LogUtils {

    public static final String PLUGIN_NAME = "[Plugin-Mq-Proxy] ";

    public static void debug(Logger logger,String s){
        debug(logger,s,null);
    }

    public static void debug(Logger logger,String s,Object o){
        if (o == null) {
            o="";
        }
        logger.debug("{}{} {}",PLUGIN_NAME,s,o);
    }

    public static void info(Logger logger,String s){
        info(logger,s,null);
    }

    public static void info(Logger logger,String s,Object o){
        if (o == null) {
            o="";
        }
        logger.info("{}{} {}",PLUGIN_NAME,s,o);
    }

    public static void warn(Logger logger,String s){
        warn(logger,s,null);
    }

    public static void warn(Logger logger,String s,Object o){
        if (o == null) {
            o="";
        }
        logger.warn("{}{} {}",PLUGIN_NAME,s,o);
    }

    public static void error(Logger logger,String s,Object o){
        if (o == null) {
            o="";
        }
        logger.error("{}{} {}",PLUGIN_NAME,s,o);
    }
}
