package com.ohaotian.plugin.mq.proxy.ext.redismq;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.impl.IProxyMessageConsumerWrapper;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;

import java.io.IOException;
import java.util.Set;

public class RedisMQMessageListener extends JedisPubSub {
    private final JedisPool jedisPool;
    private final ThreadLocal<ObjectMapper> objectMapperThreadLocal = new ThreadLocal<ObjectMapper>() {
        @Override
        protected ObjectMapper initialValue() {
            return new ObjectMapper();
        }
    };
    private Set<IProxyMessageConsumerWrapper> consumerWrapperList;

    public RedisMQMessageListener(JedisPool jedisPool, Set<IProxyMessageConsumerWrapper> consumerWrapperList) {
        this.consumerWrapperList = consumerWrapperList;
        this.jedisPool = jedisPool;
    }

    private boolean unsetOneConsumer(ProxyMessage message) {
        boolean result = false;
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            result = jedis.del(message.getMessageId()).intValue() > 0;
        } finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return result;
    }

    @Override
    public void onMessage(String channel, String message) {
        processMessage(message);
    }

    @Override
    public void onPMessage(String pattern, String channel, String message) {
        processMessage(message);
    }

    private void processMessage(String message) {
        try {
            ProxyMessage proxyMessage = objectMapperThreadLocal.get().readValue(message, ProxyMessage.class);
            if (unsetOneConsumer(proxyMessage)) {
                for (IProxyMessageConsumerWrapper messageConsumer: consumerWrapperList) {
                    if (messageConsumer.needWrapper(proxyMessage.getSubject(), proxyMessage.getTag())) {
                        messageConsumer.onMessage(proxyMessage);
                    }
                }
            }
        } catch (IOException e) {
            throw new RuntimeException("Redis parse value error", e);
        }
    }
}
