package com.ohaotian.plugin.mq.proxy.impl;

import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class ConsumerInvokeHandler implements InvocationHandler {
    private final ProxyMessageConsumer localConsumer;
    private final Set<String> tagSet;
    private final String subject;
    protected ConsumerInvokeHandler(ProxyMessageConsumer proxyMessageConsumer) {
        this.localConsumer = proxyMessageConsumer;
        tagSet = new HashSet<String>();
        String[] tags = proxyMessageConsumer.getTags();
        for (String tag: tags) {
            if (tagSet.contains(tag)) {
                continue;
            }
            tagSet.add(tag);
        }
        this.subject = proxyMessageConsumer.getSubject();
    }
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("needWrapper")) {
            return this.subject.equals(args[0]) && (tagSet.contains("*") || tagSet.contains((String) args[1]));
        }
        return method.invoke(localConsumer, args);
    }
}
