/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.redismq;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.plugin.mq.proxy.CacheStore;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.ohaotian.plugin.mq.proxy.callback.ProxyLocalTransactionExecuter;
import com.ohaotian.plugin.mq.proxy.callback.ProxySendCallback;
import com.ohaotian.plugin.mq.proxy.ext.ProxyMessageProducerEx;
import com.ohaotian.plugin.mq.proxy.ext.redismq.RedisMqTransactionCheckListener;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.status.ProxyTransactionStatus;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Transaction;

public class RedisMqMessageSender
implements ProxyMessageProducerEx,
ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final String subject;
    private final Map<ProxyMessageType, Set<String>> typeTagsMapping;
    private CacheStore cacheStore;
    private final ProxyMessageConfig messageConfig;
    private final Properties mergedProps = new Properties();
    private JedisPool jedisPool;
    private RedisMqTransactionCheckListener redisMqTransactionCheckListener;
    private final ThreadLocal<ObjectMapper> objectMapperThreadLocal = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            return new ObjectMapper();
        }
    };

    public RedisMqMessageSender(ProxyMessageConfig messageConfig, Map<ProxyMessageType, Set<String>> typeTagsMapping) {
        this.subject = messageConfig.getSubject();
        this.typeTagsMapping = typeTagsMapping;
        this.messageConfig = messageConfig;
    }

    private void setOneConsumer(Jedis jedis, ProxyMessage message) {
        Transaction tx = jedis.multi();
        tx.set(message.getMessageId(), "1");
        tx.expire(message.getMessageId(), 10);
        tx.exec();
    }

    public ProxySendResult send(ProxyMessage message) {
        ProxySendResult proxySendResult;
        this.setMessageId(message);
        this.checkStatus(message, ProxyMessageType.SYNCHRONIZATION);
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            this.setOneConsumer(jedis, message);
            jedis.publish(RedisMqMessageSender.getChannel(message), this.objectMapperThreadLocal.get().writeValueAsString((Object)message));
            proxySendResult = this.makeSendSuccessResult(message);
        }
        return proxySendResult;
    }

    public ProxySendResult sendInTransaction(ProxyMessage message, ProxyLocalTransactionExecuter localTransactionExecuter, Object arg) {
        this.setMessageId(message);
        this.checkStatus(message, ProxyMessageType.TRANSACTION);
        ProxySendResult proxySendResult = this.makeSendSuccessResult(message);
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            this.setOneConsumer(jedis, message);
            ProxyTransactionStatus transactionStatus = localTransactionExecuter.exec(message, arg);
            switch (transactionStatus) {
                case COMMIT: {
                    jedis.publish(RedisMqMessageSender.getChannel(message), this.objectMapperThreadLocal.get().writeValueAsString((Object)message));
                    break;
                }
                case ROLLBACK: {
                    break;
                }
                case UNKNOW: {
                    this.redisMqTransactionCheckListener.addCheckList(message);
                    break;
                }
            }
            this.cacheStore.set(proxySendResult.getMsgId(), (Object)ProxyTransactionStatus.COMMIT.toString(), 600);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("send tran msg msgId={" + proxySendResult.getMsgId() + "}  topic=" + message.getSubject() + " tag=" + message.getTag() + "  body={" + message.getContent() + "}  SendResult={" + proxySendResult.getStatus() + "}");
            }
        }
        return proxySendResult;
    }

    private Message getMessage(ProxyMessage message) {
        Message sendMessage;
        try {
            sendMessage = new Message(message.getSubject(), message.getTag(), message.getContent().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Convert rocketmq message error", e);
        }
        return sendMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ProxyMessage message, ProxySendCallback sendCallback) {
        block7: {
            this.setMessageId(message);
            this.checkStatus(message, ProxyMessageType.ASYNCHRONOUS);
            try (Jedis jedis = null;){
                jedis = this.jedisPool.getResource();
                this.setOneConsumer(jedis, message);
                jedis.publish(RedisMqMessageSender.getChannel(message), this.objectMapperThreadLocal.get().writeValueAsString((Object)message));
                sendCallback.onSuccess(this.makeSendSuccessResult(message));
            }
        }
    }

    private ProxySendResult makeSendSuccessResult(ProxyMessage message) {
        ProxySendResult proxySendResult = new ProxySendResult();
        proxySendResult.setStatus("SEND_OK");
        proxySendResult.setMsgId(message.getMessageId());
        return proxySendResult;
    }

    public static String getChannel(ProxyMessage message) {
        return message.getSubject() + "[" + message.getTag() + "]";
    }

    private void setMessageId(ProxyMessage message) {
        if (message.getMessageId() == null || "".equals(message.getMessageId())) {
            message.setMessageId(Long.toString(System.nanoTime()));
        }
    }

    private void checkStatus(ProxyMessage message, ProxyMessageType proxyMessageType) {
    }

    public void sendOneway(ProxyMessage message) {
        this.setMessageId(message);
        this.checkStatus(message, ProxyMessageType.ONEWAY);
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            this.setOneConsumer(jedis, message);
            jedis.publish(RedisMqMessageSender.getChannel(message), this.objectMapperThreadLocal.get().writeValueAsString((Object)message));
        }
    }

    @Override
    public void startup() {
        if (this.jedisPool != null) {
            return;
        }
        GenericObjectPoolConfig redisConfig = new GenericObjectPoolConfig();
        URI redisUri = null;
        String redisCfgUrl = this.messageConfig.getProperties().getProperty("mq.redis.url", this.mergedProps.getProperty("mq.redis.url"));
        try {
            redisUri = new URI(redisCfgUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("[" + redisCfgUrl + "] parsed error", e);
        }
        this.jedisPool = new JedisPool(redisConfig, redisUri.getHost(), redisUri.getPort(), 3000, redisUri.getUserInfo(), 0);
        this.redisMqTransactionCheckListener = new RedisMqTransactionCheckListener(this.jedisPool, this);
        this.redisMqTransactionCheckListener.startup();
    }

    @Override
    public void shutdown() {
        this.jedisPool.close();
        this.jedisPool = null;
        this.redisMqTransactionCheckListener.shtudown();
        this.redisMqTransactionCheckListener = null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap((Properties)props, (Map)this.mergedProps);
            }
        }
        this.cacheStore = (CacheStore)applicationContext.getBean(CacheStore.class);
    }
}

