package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainRspBo;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

/**
 * 作者: dmc
 * 时间: 2022/8/24 11:43
 * 描述:
 */
@HTServiceImpl
public class AgrGetAgrMainServiceImpl implements AgrGetAgrMainService{

    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrGetAgrMainRspBo getAgrMain(AgrGetAgrMainReqBo agrGetAgrMainReqBo) {
        //1 入参检验
        this.validationParam(agrGetAgrMainReqBo);
        //2 调用协议主体查询方法
        AgrAgrDo agrMain = iAgrAgrModel.getAgrMain(AgrRu.js(agrGetAgrMainReqBo, AgrAgrQryBo.class));
        //3 出参装换
        AgrGetAgrMainRspBo agrGetAgrMainRspBo = new AgrGetAgrMainRspBo();
        if (ObjectUtil.isNotEmpty(agrMain)){
            agrGetAgrMainRspBo=AgrRu.js(agrMain,AgrGetAgrMainRspBo.class);
        }
        return agrGetAgrMainRspBo;
    }

    /**
     * 入参检验
     * @param agrGetAgrMainReqBo
     */
    private void validationParam(AgrGetAgrMainReqBo agrGetAgrMainReqBo) {
        if(agrGetAgrMainReqBo.getAgrId() == null && StringUtils.isEmpty(agrGetAgrMainReqBo.getAgrCode()) ){
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR,"入参对象属性[agrId]和协议编号[agrCode]不能同时为空！");
        }
    }
}
