package com.tydic.dyc.agr.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.model.agrsync.AgrSyncRecordDo;
import com.tydic.dyc.agr.model.agrsync.IAgrSyncRecordModel;
import com.tydic.dyc.agr.model.agrsync.qrybo.AgrGetAgrItemInfoRspPageBo;
import com.tydic.dyc.agr.model.agrsync.qrybo.AgrGetSyncProcessRspPageBo;
import com.tydic.dyc.agr.model.agrsync.qrybo.AgrSyncQryBo;
import com.tydic.dyc.agr.model.agrsync.sub.AgrMainInfo;
import com.tydic.dyc.agr.model.agrsync.sub.AgrSyncProcess;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrScopeSyncBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrSyncProcessReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrSyncProcessRspBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSkuChangePriceBO;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 标题:AgrAgrSyncProcessServiceImpl
 * 说明:TODO
 * 时间:2023/1/30 11:31
 * 作者:代愿愿
 */
@HTServiceImpl
@Slf4j
public class AgrAgrSyncProcessServiceImpl implements AgrAgrSyncProcessService {
    @Autowired
    private IAgrSyncRecordModel iAgrSyncRecordModel;

    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Value("${AGR_SKU_CHANGE_TOPIC}")
    private String agrSkuChangeTopic;

    @Value("${AGR_SKU_CHANGE_TAG}")
    private String agrSkuChangeTag;

    @Resource(name = "agrSyncSkuStatusMqServiceProvider")
    private ProxyMessageProducer agrSyncSkuStatusMqServiceProvider;

    @Override
    public AgrAgrSyncProcessRspBO dealAgrSyncProcess(AgrAgrSyncProcessReqBO reqBO) {
        AgrAgrSyncProcessRspBO agrAgrSyncProcessRspBO = new AgrAgrSyncProcessRspBO();
        // 1 查询待处理的
        AgrSyncQryBo agrSyncQryBo = new AgrSyncQryBo();
        agrSyncQryBo.setProcessStatus(AgrCommConstant.ProcessStatus.TO_PROCESS);
        agrSyncQryBo.setPageNo(1);
        agrSyncQryBo.setPageSize(1);
        AgrGetSyncProcessRspPageBo agrGetSyncProcessRspPageBo = iAgrSyncRecordModel.getAgrSyncProcessByPage(agrSyncQryBo);
        if(!CollectionUtils.isEmpty(agrGetSyncProcessRspPageBo.getRows())){
            AgrSyncProcess agrSyncProcess = agrGetSyncProcessRspPageBo.getRows().get(0);
            // 1 查询协议是否存在，判断是新增还是变更
            Boolean addFlag = false;
            AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
            agrAgrQryBo.setAgrId(agrSyncProcess.getAgrId());
            AgrAgrDo agrAgrDo = iAgrAgrModel.getAgrMain(agrAgrQryBo);
            if(agrAgrDo ==null){
                addFlag = true;
            }
            // 2 更新状态为处理中=先占用
            this.updateSyncProcess(agrSyncProcess.getId(),AgrCommConstant.ProcessStatus.PROCESSING);
            try {
                // 3 处理协议信息
                this.dealAgrMain(addFlag,agrSyncProcess,agrAgrDo);
                // 4 处理协议明细信息
                this.dealAgrItem(addFlag,agrSyncProcess);
                // 5 更新状态为处理成功
                this.updateSyncProcess(agrSyncProcess.getId(),AgrCommConstant.ProcessStatus.PROCESS_SUCCESS);
            }catch (Exception e){
                // 6 更新状态为处理失败
                this.updateSyncProcess(agrSyncProcess.getId(),AgrCommConstant.ProcessStatus.PROCESS_FAIL);
            }
            agrAgrSyncProcessRspBO.setAgrId(agrSyncProcess.getAgrId());
        }

        agrAgrSyncProcessRspBO.setRespCode(AgrRspConstant.RESP_CODE_SUCCESS);

        return agrAgrSyncProcessRspBO;
    }

    private void updateSyncProcess(Long id,Integer processStatus){
        AgrSyncRecordDo agrSyncRecordDo = new AgrSyncRecordDo();
        AgrSyncProcess agrSyncProcessUpdate = new AgrSyncProcess();
        agrSyncProcessUpdate.setId(id);
        agrSyncProcessUpdate.setProcessStatus(processStatus);
        agrSyncRecordDo.setAgrSyncProcess(agrSyncProcessUpdate);
        iAgrSyncRecordModel.updateAgrSyncProcess(agrSyncRecordDo);
    }
    private void dealAgrMain(Boolean addFlag,AgrSyncProcess agrSyncProcess,AgrAgrDo agrAgrDoReq){
        AgrSyncQryBo agrSyncQryBo = new AgrSyncQryBo();
        agrSyncQryBo.setBatchNo(agrSyncProcess.getBatchNo());
        agrSyncQryBo.setAgrId(agrSyncProcess.getAgrId());
        AgrSyncRecordDo agrSyncRecordDo = iAgrSyncRecordModel.getAgrMainInfo(agrSyncQryBo);
        if(agrSyncRecordDo != null && agrSyncRecordDo.getAgrMainInfo()!=null ){
            AgrMainInfo agrMainInfo = agrSyncRecordDo.getAgrMainInfo();
            AgrAgrDo agrAgrDo = JSON.parseObject(agrMainInfo.getAgrMainJson(),AgrAgrDo.class)  ;
            agrAgrDo.setAgrId(agrSyncProcess.getAgrId());
            if(addFlag){
                // 协议新增
                iAgrAgrModel.createAgr(agrAgrDo);
            }else {
                // 协议变更
                iAgrAgrModel.updateAgr(agrAgrDo);

                Integer currentAgrStatus = agrAgrDoReq.getAgrStatus();
                Integer newAgrStatus = agrAgrDo.getAgrStatus();
                if(!currentAgrStatus.equals(newAgrStatus)){
                    boolean syncUccFlag = false;
                    // 状态发生了变更
                    Map<String, Object> content = new HashMap<>();
                    List<Long> agreementIds = new ArrayList<>();
                    agreementIds.add(agrSyncProcess.getAgrId());
                    content.put("agreementIds", agreementIds);
                    if(currentAgrStatus.equals(AgrCommConstant.AgreementStatus.ENABLE)){
                        if(newAgrStatus.equals(AgrCommConstant.AgreementStatus.FROZEN)){
                            // 启用到冻结
                            syncUccFlag = true;
                            content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.AGREEMENT_FREEZEN);
                        }
                        if(newAgrStatus.equals(AgrCommConstant.AgreementStatus.TERMINATION)){
                            // 启用到终止
                            syncUccFlag = true;
                            content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.AGREEMENT_INVALID);
                        }
                        if(newAgrStatus.equals(AgrCommConstant.AgreementStatus.TERMINATION)){
                            // 启用到过期
                            syncUccFlag = true;
                            content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.AGREEMENT_FREEZEN);
                        }
                        if(newAgrStatus.equals(AgrCommConstant.AgreementStatus.SUSPEND)) {
                            // 启用到暂停
                            syncUccFlag = true;
                            content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.AGREEMENT_FREEZEN);
                        }
                    }
                    if(newAgrStatus.equals(AgrCommConstant.AgreementStatus.ENABLE)){
                        if(currentAgrStatus.equals(AgrCommConstant.AgreementStatus.FROZEN)){
                            // 冻结到启用
                            syncUccFlag = true;
                            content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.BE_SHELF);
                        }
                        if(currentAgrStatus.equals(AgrCommConstant.AgreementStatus.TERMINATION)){
                            // 过期到启用
                            syncUccFlag = true;
                            content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.BE_SHELF);
                        }
                        if(currentAgrStatus.equals(AgrCommConstant.AgreementStatus.SUSPEND)) {
                            // 暂停到启用
                            syncUccFlag = true;
                            content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.BE_SHELF);
                        }
                    }
                    if(syncUccFlag){
                        String mesessage =  JSON.toJSONString(content);
                        this.sendMsg(mesessage);
                    }

                }
                // 同步应用范围
                List<String> appScopes = new ArrayList<>();
                agrAgrDo.getAgrAppScope().forEach(agrAppScope -> {
                    appScopes.add(agrAppScope.getScopeCode());
                });
                List<AgrAgrScopeSyncBO> agrScopeSyncBOs = new ArrayList<>();
                AgrAgrScopeSyncBO agrAgrScopeSyncBO = new AgrAgrScopeSyncBO();
                agrAgrScopeSyncBO.setAgreementId(agrSyncProcess.getAgrId());
                agrAgrScopeSyncBO.setScopeCodes(appScopes.toString());
                agrScopeSyncBOs.add(agrAgrScopeSyncBO);
                Map<String, Object> content = new HashMap<>();
                content.put("agrScopeSyncBOs",agrScopeSyncBOs);
                String mesessage =  JSON.toJSONString(content);
                this.sendMsg(mesessage);
            }
        }
    }
    private void dealAgrItem(Boolean addFlag,AgrSyncProcess agrSyncProcess){
        AgrSyncQryBo agrSyncQryBo = new AgrSyncQryBo() ;
        agrSyncQryBo.setBatchNo(agrSyncProcess.getBatchNo());
        agrSyncQryBo.setPageNo(1);
        agrSyncQryBo.setPageSize(1000);
        agrSyncQryBo.setAgrId(agrSyncProcess.getAgrId());
        AgrGetAgrItemInfoRspPageBo pageBo = iAgrSyncRecordModel.getAgrItemInfoByPage(agrSyncQryBo);
        if(pageBo.getTotal()>0){
            int total = pageBo.getTotal();
            for (int i=1;i<=total;i++) {
                agrSyncQryBo.setPageNo(i);
                agrSyncQryBo.setPageSize(1000);
                AgrGetAgrItemInfoRspPageBo pageBo2 = iAgrSyncRecordModel.getAgrItemInfoByPage(agrSyncQryBo);
                AgrAgrDo agrAgrDo = new AgrAgrDo();
                agrAgrDo.setAgrId(agrSyncProcess.getAgrId());
                if(addFlag){
                    // 协议新增
                    List<AgrItem> agrItems = new ArrayList<>();
                    pageBo2.getRows().forEach(agrItemInfo -> {
                        AgrItem agrItem = JSON.parseObject(agrItemInfo.getAgrItemJson(),AgrItem.class);
                        agrItems.add(agrItem);
                    });
                    agrAgrDo.setAgrItem(agrItems);
                    iAgrAgrModel.saveAgrItem(agrAgrDo);
                }else {
                    // 协议变更
                    // 删除的协议明细
                    List<Long> deleteAgrItemIds = new ArrayList<>();
                    // 新增的协议明细
                    List<AgrItem> addAgrItems = new ArrayList<>();
                    // 修改的协议明细
                    List<AgrItem> updateAgrItems = new ArrayList<>();
                    pageBo2.getRows().forEach(agrItemInfo -> {
                        if(agrItemInfo.getItemChngType().equals(AgrCommConstant.AgreementSkuChangeType.DELETE)){
                            deleteAgrItemIds.add(agrItemInfo.getAgrItemId());
                        }
                        if(agrItemInfo.getItemChngType().equals(AgrCommConstant.AgreementSkuChangeType.ADD)){
                            AgrItem agrItem = JSON.parseObject(agrItemInfo.getAgrItemJson(),AgrItem.class);
                            addAgrItems.add(agrItem);
                        }
                        if(agrItemInfo.getItemChngType().equals(AgrCommConstant.AgreementSkuChangeType.UPDATE)){
                            AgrItem agrItem = JSON.parseObject(agrItemInfo.getAgrItemJson(),AgrItem.class);
                            updateAgrItems.add(agrItem);
                        }
                    });
                    // 处理协议明细删除
                    this.dealItemDelete(agrAgrDo,deleteAgrItemIds);
                    // 处理协议明细新增
                    if(!CollectionUtils.isEmpty(addAgrItems)){
                        agrAgrDo.setAgrItem(addAgrItems);
                        iAgrAgrModel.saveAgrItem(agrAgrDo);
                    }
                    // 处理协议明细修改
                    this.dealItemUpdate(agrAgrDo,updateAgrItems);
                }
            }
        }
    }
    private void dealItemUpdate(AgrAgrDo agrAgrDo,List<AgrItem> updateAgrItems){
        if(!CollectionUtils.isEmpty(updateAgrItems)){
            agrAgrDo.setAgrItem(updateAgrItems);
            iAgrAgrModel.updateAgrItemByBatch(agrAgrDo);
            List<AgrSkuChangePriceBO> skuChangePriceBOs = new ArrayList<>();
            updateAgrItems.forEach(agrItem -> {
                AgrSkuChangePriceBO agrSkuChangePriceBO = new AgrSkuChangePriceBO();
                agrSkuChangePriceBO.setAgreementId(agrAgrDo.getAgrId());
                agrSkuChangePriceBO.setAgreementSkuId(agrItem.getAgrItemId());
                try {
                    agrSkuChangePriceBO.setSalePrice(MoneyUtils.BigDecimal2Long(agrItem.getSalePrice()));
                    agrSkuChangePriceBO.setBuyPrice(MoneyUtils.BigDecimal2Long(agrItem.getBuyPrice()));
                } catch (Exception e) {
                    log.info(e.getMessage());
                }
                skuChangePriceBOs.add(agrSkuChangePriceBO);
            });
            Map<String, Object> content = new HashMap<>();
            content.put("skuChangePriceBOs",skuChangePriceBOs);
            // 发消息
            this.sendMsg(JSON.toJSONString(content));
        }
    }

    private void dealItemDelete(AgrAgrDo agrAgrDo,List<Long> deleteAgrItemIds){
        if(!CollectionUtils.isEmpty(deleteAgrItemIds)){
            List<AgrItem> addAgrItem1 = new ArrayList<>();
            AgrItem agrItem = new AgrItem();
            agrItem.setAgrItemIds(deleteAgrItemIds);
            addAgrItem1.add(agrItem);
            agrAgrDo.setAgrItem(addAgrItem1);
            iAgrAgrModel.deleteAgrItemByBatch(agrAgrDo);

            Map<String, Object> content = new HashMap<>();
            List<Long> agreementIds = new ArrayList<>();
            agreementIds.add(agrAgrDo.getAgrId());
            content.put("agreementIds", agreementIds);
            content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.AGREEMENT_INVALID);
            content.put("agreementSkuIds",deleteAgrItemIds);
            // 发消息
            this.sendMsg(JSON.toJSONString(content));

        }
    }
    /**
     * 发送消息
     */
    private void sendMsg(String content){
        if(StringUtils.hasText(content)){
            log.info("发消息同步商品商品中心入参为"+content);
            agrSyncSkuStatusMqServiceProvider.send(new ProxyMessage(agrSkuChangeTopic, agrSkuChangeTag, content));
            log.info("发消息同步商品商品中心成功");
        }

    }

}
