package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrAllocateRecordListRspBO;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrAllocateRecordListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrAllocateRecordListRspBO;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:AgrGetAgrAllocateRecordListServiceImpl
 * 说明:TODO
 * 时间:2022/9/6 14:55
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrGetAgrAllocateRecordListServiceImpl implements AgrGetAgrAllocateRecordListService {

    @Autowired
    private IAgrAgrModel agrAgrModel;

    @Override
    public AgrGetAgrAllocateRecordListRspBO getAgrAllocateRecordList(AgrGetAgrAllocateRecordListReqBO allocateRecordListReqBO) {
        //1 参数检验
        this.validationParam(allocateRecordListReqBO);
        //2 数据组装
        AgrAgrQryBo agrAgrQryBo = AgrRu.js(allocateRecordListReqBO, AgrAgrQryBo.class);
        AgrGetAgrAllocateRecordListRspBO rspBO = new AgrGetAgrAllocateRecordListRspBO();
        //3 调用协议分配记录列表查询方法
        AgrAgrAllocateRecordListRspBO agrAllocateRecordList = agrAgrModel.getAgrAllocateRecordList(agrAgrQryBo);
        //4 转换为出参数据类型
        if (ObjectUtil.isNotEmpty(agrAllocateRecordList)) {
            rspBO = AgrRu.js(agrAllocateRecordList, AgrGetAgrAllocateRecordListRspBO.class);
        }

        return rspBO;
    }

    /**
     * 入参检验
     * @param allocateRecordListReqBO allocateRecordListReqBO
     */
    private void validationParam(AgrGetAgrAllocateRecordListReqBO allocateRecordListReqBO) {
        if (ObjectUtil.isEmpty(allocateRecordListReqBO.getAgrId())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议ID]不能为空");
        }
        if (ObjectUtil.isEmpty(allocateRecordListReqBO.getAgrVersion())) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象属性[协议版本号]不能为空");
        }
    }
}
