package com.tydic.dyc.agr.service.procinst;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.qrybo.AgrTaskQryBo;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetTaskInstReqBo;
import com.tydic.dyc.agr.service.procinst.bo.AgrGetTaskInstRspBo;
import com.tydic.dyc.agr.service.procinst.bo.AgrUocOrderTaskInstBo;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @desc:
 * @author: PingZi
 * @date: 2022/8/24 10:50
 */
@HTServiceImpl
public class AgrGetTaskInstServiceImpl implements AgrGetTaskInstService {

    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;

    @Override
    public AgrGetTaskInstRspBo getTaskInstList(AgrGetTaskInstReqBo reqBo) {
        validateParams(reqBo);
        AgrTaskQryBo agrTaskQryBo = JSONObject.parseObject(JSON.toJSONString(reqBo), AgrTaskQryBo.class);
        AgrProcInstDo agrProcInstDo = iAgrProcInstModel.getTaskList(agrTaskQryBo);
        AgrGetTaskInstRspBo rspBo = AgrRu.success(AgrGetTaskInstRspBo.class);
        rspBo.setRows(AgrRu.jsl(agrProcInstDo.getAgrUocOrderTaskInst(), AgrUocOrderTaskInstBo.class));
        return rspBo;
    }

    private void validateParams(AgrGetTaskInstReqBo agrGetTaskInstReqBo) {
        if (ObjectUtil.isEmpty(agrGetTaskInstReqBo.getOrderId())) {
            throw new BaseBusinessException("", "入参对象属性[订单ID]不能为空");
        }
    }
}
