/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.components.es.AgrElasticsearchUtil;
import com.tydic.dyc.agr.components.es.AgrEsSyncManager;
import com.tydic.dyc.agr.components.es.AgrEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.agr.config.AgrIndexConfig;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.service.agr.AgrEsSyncService;
import com.tydic.dyc.agr.service.agr.bo.AgrEsSyncServiceReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrEsSyncServiceRspBo;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrEsSyncService"})
public class AgrEsSyncServiceImpl
implements AgrEsSyncService {
    private static final Logger log = LoggerFactory.getLogger(AgrEsSyncServiceImpl.class);
    @Autowired
    private AgrEsSyncManager agrEsSyncManager;
    @Autowired
    private AgrIndexConfig agrIndexConfig;
    @Autowired
    private AgrElasticsearchUtil agrElasticsearchUtil;
    @Autowired
    private IAgrAgrModel agrAgrModel;

    @PostMapping(value={"sync"})
    public AgrEsSyncServiceRspBo sync(@RequestBody AgrEsSyncServiceReqBo reqBo) {
        this.validateArg(reqBo);
        if (!reqBo.getAll().booleanValue()) {
            AgrEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = AgrRu.js(reqBo, AgrEsSyncManagerSaveDataReqBo.class);
            this.agrEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            return AgrRu.success(AgrEsSyncServiceRspBo.class);
        }
        if (this.agrIndexConfig.getAgrIndex().equals(reqBo.getIndexName())) {
            this.delIdx(this.agrIndexConfig.getAgrIndex());
            this.syncSale();
        }
        return AgrRu.success(AgrEsSyncServiceRspBo.class);
    }

    private void syncSale() {
        List<AgrAgrDo> allAgrList = this.getAllAgrList();
        if (ObjectUtil.isNotEmpty(allAgrList)) {
            for (AgrAgrDo agrAgrDo : allAgrList) {
                AgrEsSyncManagerSaveDataReqBo agrEsSyncManagerSaveDataReqBo = new AgrEsSyncManagerSaveDataReqBo();
                agrEsSyncManagerSaveDataReqBo.setAgrId(agrAgrDo.getAgrId());
                agrEsSyncManagerSaveDataReqBo.setIndexName(this.agrIndexConfig.getAgrIndex());
                agrEsSyncManagerSaveDataReqBo.setObjId(agrAgrDo.getAgrId());
                this.agrEsSyncManager.saveData(agrEsSyncManagerSaveDataReqBo);
            }
        }
    }

    private List<AgrAgrDo> getAllAgrList() {
        return this.agrAgrModel.getAllAgrList().getRows();
    }

    private void delIdx(String idx) {
        block2: {
            try {
                this.agrElasticsearchUtil.deleteIndex(idx);
            }
            catch (Exception e) {
                String eCause = JSON.toJSONString((Object)e.getCause());
                log.error(eCause);
                if (!eCause.contains("index_not_found_exception")) break block2;
                log.info("\u7d22\u5f15\u4e0d\u5b58\u5728");
            }
        }
    }

    private void validateArg(AgrEsSyncServiceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!reqBo.getAll().booleanValue()) {
            if (null == reqBo.getObjId()) {
                throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61ID\u4e3a\u7a7a");
            }
            if (null == reqBo.getAgrId()) {
                throw new BaseBusinessException("0001", "\u5165\u53c2\u534f\u8baeID\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBo.getIndexName())) {
                throw new BaseBusinessException("0001", "\u5165\u53c2\u7d22\u5f15\u540d\u4e3a\u7a7a");
            }
        }
    }
}

