package com.tydic.dyc.agr.service.agr;

import com.tydic.dyc.agr.model.common.AgrCommonDo;
import com.tydic.dyc.agr.model.common.IAgrCommonModel;
import com.tydic.dyc.agr.model.common.sub.ComBatchDealRrecord;
import com.tydic.dyc.agr.service.agr.bo.AgrAddBatchDealRecordReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAddBatchDealRecordRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题:AgrAddBatchDealRecordServiceImpl
 * 说明:TODO
 * 时间:2023/4/13 17:30
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrAddBatchDealRecordServiceImpl implements AgrAddBatchDealRecordService {
    @Autowired
    private IAgrCommonModel iAgrCommonModel;
    @Override
    public AgrAddBatchDealRecordRspBO addBatchDealRecord(AgrAddBatchDealRecordReqBO agrAddBatchDealRecordReqBO) {
        AgrAddBatchDealRecordRspBO rspBO = AgrRu.success(AgrAddBatchDealRecordRspBO.class);
        if(!CollectionUtils.isEmpty(agrAddBatchDealRecordReqBO.getComBatchDealRrecord())){
            AgrCommonDo agrCommonDo = new AgrCommonDo();
            String batchNo = IdUtil.nextId()+"";
            List<ComBatchDealRrecord> comBatchDealRrecord = AgrRu.jsl(agrAddBatchDealRecordReqBO.getComBatchDealRrecord(), ComBatchDealRrecord.class);
            comBatchDealRrecord.forEach(comBatchDealRrecord1 -> {
                comBatchDealRrecord1.setBatchNo(batchNo);
            });
            agrCommonDo.setComBatchDealRrecord(comBatchDealRrecord);
            agrCommonDo.setUserId(agrAddBatchDealRecordReqBO.getUserId());
            agrCommonDo.setUsername(agrAddBatchDealRecordReqBO.getUsername());
            this.iAgrCommonModel.addBatchDealRecord(agrCommonDo);
            rspBO.setBatchNo(batchNo);
        }
        return rspBO;
    }
}
