package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.components.es.AgrElasticsearchUtil;
import com.tydic.dyc.agr.components.es.AgrEsSyncManager;
import com.tydic.dyc.agr.components.es.AgrEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.agr.config.AgrIndexConfig;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.service.agr.bo.AgrEsSyncServiceReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrEsSyncServiceRspBo;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题:AgrEsSyncServiceImpl
 * 说明:
 * 时间:2022/8/29 15:05
 * 作者:田桂银
 */
@HTServiceImpl
@Slf4j
public class AgrEsSyncServiceImpl implements AgrEsSyncService {

    @Autowired
    private AgrEsSyncManager agrEsSyncManager;

    @Autowired
    private AgrIndexConfig agrIndexConfig;

    @Autowired
    private AgrElasticsearchUtil agrElasticsearchUtil;

    @Autowired
    private IAgrAgrModel agrAgrModel;

    @Override
    public AgrEsSyncServiceRspBo sync(AgrEsSyncServiceReqBo reqBo) {
        validateArg(reqBo);
        if (!reqBo.getAll()) {
            AgrEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = AgrRu.js(reqBo, AgrEsSyncManagerSaveDataReqBo.class);
            agrEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            return AgrRu.success(AgrEsSyncServiceRspBo.class);
        }
        if (agrIndexConfig.getAgrIndex().equals(reqBo.getIndexName())) {
            delIdx(agrIndexConfig.getAgrIndex());
            syncSale();
        }
        return AgrRu.success(AgrEsSyncServiceRspBo.class);
    }


    private void syncSale() {
        //获取所有协议主体数据
        List<AgrAgrDo> allAgrList = getAllAgrList();
        if (ObjectUtil.isNotEmpty(allAgrList)) {
            for (AgrAgrDo agrAgrDo : allAgrList) {
                AgrEsSyncManagerSaveDataReqBo agrEsSyncManagerSaveDataReqBo = new AgrEsSyncManagerSaveDataReqBo();
                agrEsSyncManagerSaveDataReqBo.setAgrId(agrAgrDo.getAgrId());
                agrEsSyncManagerSaveDataReqBo.setIndexName(agrIndexConfig.getAgrIndex());
                agrEsSyncManagerSaveDataReqBo.setObjId(agrAgrDo.getAgrId());
                agrEsSyncManager.saveData(agrEsSyncManagerSaveDataReqBo);
            }
        }

    }

    //查询所有主体
    private List<AgrAgrDo> getAllAgrList() {
        return agrAgrModel.getAllAgrList().getRows();
    }

    /**
     * 删除索引
     */
    private void delIdx(String idx) {
        try {
            agrElasticsearchUtil.deleteIndex(idx);
        } catch (Exception e) {
            String eCause = JSON.toJSONString(e.getCause());
            log.error(eCause);
            if (eCause.contains(AgrIndexConfig.INDEX_EXCEPTION)) {
                log.info("索引不存在");
            }
        }
    }

    private void validateArg(AgrEsSyncServiceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象为空");
        }
        if (!reqBo.getAll()) {
            if (null == reqBo.getObjId()) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参对象ID为空");
            }
            if (null == reqBo.getAgrId()) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参协议ID为空");
            }
            if (StringUtils.isBlank(reqBo.getIndexName())) {
                throw new BaseBusinessException(AgrRspConstant.RESP_CODE_COMMON_PARAM_FIELD_EMPTY_ERROR, "入参索引名为空");
            }
        }
    }
}


