package com.tydic.dyc.agr.service.agr;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrMainListRspQryBo;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainListReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrMainListRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrMainListBo;
import com.tydic.dyc.agr.service.constants.AgrRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * @title: AgrGetAgrMainListServiceImpl
 * @describe： 协议主体列表查询服务实现
 * @created: 2022/9/15 15:45
 * @author: FKC
 */
@Slf4j
@HTServiceImpl
public class AgrGetAgrMainListServiceImpl implements AgrGetAgrMainListService{
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @Override
    public AgrGetAgrMainListRspBO getAgrMainList(AgrGetAgrMainListReqBO agrGetAgrMainListReqBO) {
        //1 组装协议主题信息查询入参
        AgrAgrQryBo agrAgrQryBo = JSON.parseObject(JSON.toJSONString(agrGetAgrMainListReqBO),AgrAgrQryBo.class);
        //2 调用协议主体列表查询方法
        AgrGetAgrMainListRspQryBo agrGetAgrMainListRspQryBo = this.iAgrAgrModel.getAgrMainList(agrAgrQryBo);
        List<AgrAgrDo> agrAgrDos = agrGetAgrMainListRspQryBo.getRows();
        //3 出参属性类型装换
        List<AgrMainListBo> rows = JSONArray.parseArray(JSON.toJSONString(agrAgrDos)).toJavaList(AgrMainListBo.class);
        //4 出参设置
        AgrGetAgrMainListRspBO agrGetAgrMainListRspBO = new AgrGetAgrMainListRspBO();
        agrGetAgrMainListRspBO.setRows(rows);
        return agrGetAgrMainListRspBO;
    }
}
