package com.tydic.dyc.agr.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrAdjustCfg;
import com.tydic.dyc.agr.model.agr.sub.AgrAppScope;
import com.tydic.dyc.agr.model.agr.sub.AgrMainExt;
import com.tydic.dyc.agr.model.agr.sub.AgrPayConfig;
import com.tydic.dyc.agr.model.agrchange.AgrChngApplyDo;
import com.tydic.dyc.agr.model.agrchange.IAgrChngApplyModel;
import com.tydic.dyc.agr.model.agrchange.qrybo.AgrAgrChngApplyQryBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrMainChngAuditCallBackReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrMainChngAuditCallBackRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:AgrAgrMainChngAuditCallBackServiceImpl
 * 说明:TODO
 * 时间:2022/9/23 13:03
 * 作者:代愿愿
 */
@HTServiceImpl
public class AgrAgrMainChngAuditCallBackServiceImpl implements AgrAgrMainChngAuditCallBackService {
    @Autowired
    private IAgrChngApplyModel iAgrChngApplyModel;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Override
    public AgrAgrMainChngAuditCallBackRspBO dealMainChngAuditCallBack(AgrAgrMainChngAuditCallBackReqBO reqBO) {
        // 1 调用变更申请状态变更
        this.invokeUpdateAgrChngApplyMain(reqBO);
        // 2 查询协议主体变更详情
        AgrChngApplyDo agrChngApplyDo = this.getAgrMainChngDetail(reqBO);
        // 3 查询协议详情
        AgrAgrDo agrAgrDo = this.getAgrDetail(reqBO);
        // 4 调用协议修改
        this.updateAgr(agrChngApplyDo,agrAgrDo);
        return AgrRu.success(AgrAgrMainChngAuditCallBackRspBO.class);
    }
    /**
     * 修改协议信息
     */
    private void updateAgr(AgrChngApplyDo agrChngApplyDo,AgrAgrDo agrAgrDo1){
        AgrAgrDo agrAgrDo = JSON.parseObject(JSON.toJSONString(agrChngApplyDo.getAgrMainChng()),AgrAgrDo.class);
        agrAgrDo.setAgrMainExt(JSON.parseArray(JSON.toJSONString(agrChngApplyDo.getAgrMainExtChng()), AgrMainExt.class));
        agrAgrDo.setAgrPayConfig(JSON.parseArray(JSON.toJSONString(agrChngApplyDo.getAgrPayConfigChng()), AgrPayConfig.class));
        agrAgrDo.setAgrAdjustCfg(JSON.parseObject(JSON.toJSONString(agrChngApplyDo.getAgrAdjustCfgChng()), AgrAdjustCfg.class));
        agrAgrDo.setAgrAppScope(JSON.parseArray(JSON.toJSONString(agrChngApplyDo.getAgrAppScopeChng()), AgrAppScope.class));
        // 未变更数据
        agrAgrDo.setAgrAccessory(agrAgrDo1.getAgrAccessory());
        agrAgrDo.setAgrCataScope(agrAgrDo1.getAgrCataScope());
        agrAgrDo.setAgrRel(agrAgrDo1.getAgrRel());
        this.iAgrAgrModel.updateAgr(agrAgrDo);

    }
    /**
     * 查询协议详情
     */
    private AgrAgrDo getAgrDetail(AgrAgrMainChngAuditCallBackReqBO reqBO){
        AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
        agrAgrQryBo.setAgrId(reqBO.getAgrId());
        AgrAgrDo agrAgrDo = this.iAgrAgrModel.getAgrDetail(agrAgrQryBo);
        return agrAgrDo;
    }
    /**
     * 查询协议主体变更详情
     */
    private AgrChngApplyDo getAgrMainChngDetail(AgrAgrMainChngAuditCallBackReqBO reqBO){
        AgrAgrChngApplyQryBo agrAgrChngApplyQryBo = new AgrAgrChngApplyQryBo();
        agrAgrChngApplyQryBo.setAgrId(reqBO.getAgrId());
        agrAgrChngApplyQryBo.setChngApplyId(reqBO.getChngApplyId());
        AgrChngApplyDo agrChngApplyDo = this.iAgrChngApplyModel.getAgrMainChngDetail(agrAgrChngApplyQryBo);
        return agrChngApplyDo;
    }
    /**
     * 调用变更申请状态变更
     */
    private void invokeUpdateAgrChngApplyMain(AgrAgrMainChngAuditCallBackReqBO reqBO){
        AgrChngApplyDo agrChngApplyDo = new AgrChngApplyDo();
        agrChngApplyDo.setAgrId(reqBO.getAgrId());
        agrChngApplyDo.setChngApplyId(reqBO.getChngApplyId());
        agrChngApplyDo.setChngApplyStatus(AgrCommConstant.ChangeApplyStatus.PASS);
        this.iAgrChngApplyModel.updateAgrChngApplyMain(agrChngApplyDo);
    }
}
