/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.agr;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrVersionListReqBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrGetAgrVersionListRspBo;
import com.tydic.dyc.agr.service.agr.AgrGetAgrVersionService;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrVersionReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrGetAgrVersionRspBO;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrGetAgrVersionService"})
public class AgrGetAgrVersionServiceImpl
implements AgrGetAgrVersionService {
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @PostMapping(value={"getAgrVersionList"})
    public AgrGetAgrVersionRspBO getAgrVersionList(@RequestBody AgrGetAgrVersionReqBO reqBO) {
        this.validateParam(reqBO);
        AgrGetAgrVersionListReqBo agrGetAgrVersionListReqBo = AgrRu.js(reqBO, AgrGetAgrVersionListReqBo.class);
        AgrGetAgrVersionListRspBo agrGetAgrVersionListRspBo = this.iAgrAgrModel.getAgrVersionList(agrGetAgrVersionListReqBo);
        AgrGetAgrVersionRspBO rspBO = AgrRu.js(agrGetAgrVersionListRspBo, AgrGetAgrVersionRspBO.class);
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            rspBO.getRows().forEach(agrAgrVersionBo -> {
                agrAgrVersionBo.setVersionStatusStr(AgrCommConstant.VersionStatusEnum.getValueByCode((Integer)agrAgrVersionBo.getVersionStatus()));
                agrAgrVersionBo.setChngTypeStr(AgrCommConstant.AgrChngTypeEnum.getValueByCode((Integer)agrAgrVersionBo.getChngType()));
            });
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void validateParam(AgrGetAgrVersionReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getAgrId() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[agrId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

