/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.domainservice;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.sub.AgrItem;
import com.tydic.dyc.agr.model.agrsync.AgrSyncRecordDo;
import com.tydic.dyc.agr.model.agrsync.IAgrSyncRecordModel;
import com.tydic.dyc.agr.model.agrsync.qrybo.AgrGetAgrItemInfoRspPageBo;
import com.tydic.dyc.agr.model.agrsync.qrybo.AgrGetSyncProcessRspPageBo;
import com.tydic.dyc.agr.model.agrsync.qrybo.AgrSyncQryBo;
import com.tydic.dyc.agr.model.agrsync.sub.AgrMainInfo;
import com.tydic.dyc.agr.model.agrsync.sub.AgrSyncProcess;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.AgrAgrSyncProcessService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrScopeSyncBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrSyncProcessReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrAgrSyncProcessRspBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSkuChangePriceBO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.domainservice.AgrAgrSyncProcessService"})
public class AgrAgrSyncProcessServiceImpl
implements AgrAgrSyncProcessService {
    private static final Logger log = LoggerFactory.getLogger(AgrAgrSyncProcessServiceImpl.class);
    @Autowired
    private IAgrSyncRecordModel iAgrSyncRecordModel;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;
    @Value(value="${AGR_SKU_CHANGE_TOPIC}")
    private String agrSkuChangeTopic;
    @Value(value="${AGR_SKU_CHANGE_TAG}")
    private String agrSkuChangeTag;
    @Resource(name="agrSyncSkuStatusMqServiceProvider")
    private ProxyMessageProducer agrSyncSkuStatusMqServiceProvider;

    @PostMapping(value={"dealAgrSyncProcess"})
    public AgrAgrSyncProcessRspBO dealAgrSyncProcess(@RequestBody AgrAgrSyncProcessReqBO reqBO) {
        AgrAgrSyncProcessRspBO agrAgrSyncProcessRspBO = new AgrAgrSyncProcessRspBO();
        AgrSyncQryBo agrSyncQryBo = new AgrSyncQryBo();
        agrSyncQryBo.setProcessStatus(AgrCommConstant.ProcessStatus.TO_PROCESS);
        agrSyncQryBo.setPageNo(1);
        agrSyncQryBo.setPageSize(1);
        AgrGetSyncProcessRspPageBo agrGetSyncProcessRspPageBo = this.iAgrSyncRecordModel.getAgrSyncProcessByPage(agrSyncQryBo);
        if (!CollectionUtils.isEmpty(agrGetSyncProcessRspPageBo.getRows())) {
            AgrSyncProcess agrSyncProcess = agrGetSyncProcessRspPageBo.getRows().get(0);
            Boolean addFlag = false;
            AgrAgrQryBo agrAgrQryBo = new AgrAgrQryBo();
            agrAgrQryBo.setAgrId(agrSyncProcess.getAgrId());
            AgrAgrDo agrAgrDo = this.iAgrAgrModel.getAgrMain(agrAgrQryBo);
            if (agrAgrDo == null) {
                addFlag = true;
            }
            this.updateSyncProcess(agrSyncProcess.getId(), AgrCommConstant.ProcessStatus.PROCESSING);
            try {
                this.dealAgrMain(addFlag, agrSyncProcess, agrAgrDo);
                this.dealAgrItem(addFlag, agrSyncProcess);
                this.updateSyncProcess(agrSyncProcess.getId(), AgrCommConstant.ProcessStatus.PROCESS_SUCCESS);
            }
            catch (Exception e) {
                this.updateSyncProcess(agrSyncProcess.getId(), AgrCommConstant.ProcessStatus.PROCESS_FAIL);
            }
            agrAgrSyncProcessRspBO.setAgrId(agrSyncProcess.getAgrId());
        }
        agrAgrSyncProcessRspBO.setRespCode("0000");
        return agrAgrSyncProcessRspBO;
    }

    private void updateSyncProcess(Long id, Integer processStatus) {
        AgrSyncRecordDo agrSyncRecordDo = new AgrSyncRecordDo();
        AgrSyncProcess agrSyncProcessUpdate = new AgrSyncProcess();
        agrSyncProcessUpdate.setId(id);
        agrSyncProcessUpdate.setProcessStatus(processStatus);
        agrSyncRecordDo.setAgrSyncProcess(agrSyncProcessUpdate);
        this.iAgrSyncRecordModel.updateAgrSyncProcess(agrSyncRecordDo);
    }

    private void dealAgrMain(Boolean addFlag, AgrSyncProcess agrSyncProcess, AgrAgrDo agrAgrDoReq) {
        AgrSyncQryBo agrSyncQryBo = new AgrSyncQryBo();
        agrSyncQryBo.setBatchNo(agrSyncProcess.getBatchNo());
        agrSyncQryBo.setAgrId(agrSyncProcess.getAgrId());
        AgrSyncRecordDo agrSyncRecordDo = this.iAgrSyncRecordModel.getAgrMainInfo(agrSyncQryBo);
        if (agrSyncRecordDo != null && agrSyncRecordDo.getAgrMainInfo() != null) {
            AgrMainInfo agrMainInfo = agrSyncRecordDo.getAgrMainInfo();
            AgrAgrDo agrAgrDo = (AgrAgrDo)JSON.parseObject((String)agrMainInfo.getAgrMainJson(), AgrAgrDo.class);
            agrAgrDo.setAgrId(agrSyncProcess.getAgrId());
            if (addFlag.booleanValue()) {
                this.iAgrAgrModel.createAgr(agrAgrDo);
            } else {
                this.iAgrAgrModel.updateAgr(agrAgrDo);
                Integer currentAgrStatus = agrAgrDoReq.getAgrStatus();
                Integer newAgrStatus = agrAgrDo.getAgrStatus();
                if (!currentAgrStatus.equals(newAgrStatus)) {
                    boolean syncUccFlag = false;
                    HashMap<String, Serializable> content = new HashMap<String, Serializable>();
                    ArrayList<Long> agreementIds = new ArrayList<Long>();
                    agreementIds.add(agrSyncProcess.getAgrId());
                    content.put("agreementIds", agreementIds);
                    if (currentAgrStatus.equals(AgrCommConstant.AgreementStatus.ENABLE)) {
                        if (newAgrStatus.equals(AgrCommConstant.AgreementStatus.FROZEN)) {
                            syncUccFlag = true;
                            content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.AGREEMENT_FREEZEN);
                        }
                        if (newAgrStatus.equals(AgrCommConstant.AgreementStatus.TERMINATION)) {
                            syncUccFlag = true;
                            content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.AGREEMENT_INVALID);
                        }
                        if (newAgrStatus.equals(AgrCommConstant.AgreementStatus.TERMINATION)) {
                            syncUccFlag = true;
                            content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.AGREEMENT_FREEZEN);
                        }
                        if (newAgrStatus.equals(AgrCommConstant.AgreementStatus.SUSPEND)) {
                            syncUccFlag = true;
                            content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.AGREEMENT_FREEZEN);
                        }
                    }
                    if (newAgrStatus.equals(AgrCommConstant.AgreementStatus.ENABLE)) {
                        if (currentAgrStatus.equals(AgrCommConstant.AgreementStatus.FROZEN)) {
                            syncUccFlag = true;
                            content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.BE_SHELF);
                        }
                        if (currentAgrStatus.equals(AgrCommConstant.AgreementStatus.TERMINATION)) {
                            syncUccFlag = true;
                            content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.BE_SHELF);
                        }
                        if (currentAgrStatus.equals(AgrCommConstant.AgreementStatus.SUSPEND)) {
                            syncUccFlag = true;
                            content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.BE_SHELF);
                        }
                    }
                    if (syncUccFlag) {
                        String mesessage = JSON.toJSONString(content);
                        this.sendMsg(mesessage);
                    }
                }
                ArrayList appScopes = new ArrayList();
                agrAgrDo.getAgrAppScope().forEach(agrAppScope -> appScopes.add(agrAppScope.getScopeCode()));
                ArrayList<AgrAgrScopeSyncBO> agrScopeSyncBOs = new ArrayList<AgrAgrScopeSyncBO>();
                AgrAgrScopeSyncBO agrAgrScopeSyncBO = new AgrAgrScopeSyncBO();
                agrAgrScopeSyncBO.setAgreementId(agrSyncProcess.getAgrId());
                agrAgrScopeSyncBO.setScopeCodes(((Object)appScopes).toString());
                agrScopeSyncBOs.add(agrAgrScopeSyncBO);
                HashMap<String, ArrayList<AgrAgrScopeSyncBO>> content = new HashMap<String, ArrayList<AgrAgrScopeSyncBO>>();
                content.put("agrScopeSyncBOs", agrScopeSyncBOs);
                String mesessage = JSON.toJSONString(content);
                this.sendMsg(mesessage);
            }
        }
    }

    private void dealAgrItem(Boolean addFlag, AgrSyncProcess agrSyncProcess) {
        AgrSyncQryBo agrSyncQryBo = new AgrSyncQryBo();
        agrSyncQryBo.setBatchNo(agrSyncProcess.getBatchNo());
        agrSyncQryBo.setPageNo(1);
        agrSyncQryBo.setPageSize(1000);
        agrSyncQryBo.setAgrId(agrSyncProcess.getAgrId());
        AgrGetAgrItemInfoRspPageBo pageBo = this.iAgrSyncRecordModel.getAgrItemInfoByPage(agrSyncQryBo);
        if (pageBo.getTotal() > 0) {
            int total = pageBo.getTotal();
            for (int i = 1; i <= total; ++i) {
                agrSyncQryBo.setPageNo(i);
                agrSyncQryBo.setPageSize(1000);
                AgrGetAgrItemInfoRspPageBo pageBo2 = this.iAgrSyncRecordModel.getAgrItemInfoByPage(agrSyncQryBo);
                AgrAgrDo agrAgrDo = new AgrAgrDo();
                agrAgrDo.setAgrId(agrSyncProcess.getAgrId());
                if (addFlag.booleanValue()) {
                    ArrayList<AgrItem> agrItems = new ArrayList<AgrItem>();
                    pageBo2.getRows().forEach(agrItemInfo -> {
                        AgrItem agrItem = (AgrItem)JSON.parseObject((String)agrItemInfo.getAgrItemJson(), AgrItem.class);
                        agrItems.add(agrItem);
                    });
                    agrAgrDo.setAgrItem(agrItems);
                    this.iAgrAgrModel.saveAgrItem(agrAgrDo);
                    continue;
                }
                ArrayList<Long> deleteAgrItemIds = new ArrayList<Long>();
                ArrayList<AgrItem> addAgrItems = new ArrayList<AgrItem>();
                ArrayList<AgrItem> updateAgrItems = new ArrayList<AgrItem>();
                pageBo2.getRows().forEach(agrItemInfo -> {
                    AgrItem agrItem;
                    if (agrItemInfo.getItemChngType().equals(AgrCommConstant.AgreementSkuChangeType.DELETE)) {
                        deleteAgrItemIds.add(agrItemInfo.getAgrItemId());
                    }
                    if (agrItemInfo.getItemChngType().equals(AgrCommConstant.AgreementSkuChangeType.ADD)) {
                        agrItem = (AgrItem)JSON.parseObject((String)agrItemInfo.getAgrItemJson(), AgrItem.class);
                        addAgrItems.add(agrItem);
                    }
                    if (agrItemInfo.getItemChngType().equals(AgrCommConstant.AgreementSkuChangeType.UPDATE)) {
                        agrItem = (AgrItem)JSON.parseObject((String)agrItemInfo.getAgrItemJson(), AgrItem.class);
                        updateAgrItems.add(agrItem);
                    }
                });
                this.dealItemDelete(agrAgrDo, deleteAgrItemIds);
                if (!CollectionUtils.isEmpty(addAgrItems)) {
                    agrAgrDo.setAgrItem(addAgrItems);
                    this.iAgrAgrModel.saveAgrItem(agrAgrDo);
                }
                this.dealItemUpdate(agrAgrDo, updateAgrItems);
            }
        }
    }

    private void dealItemUpdate(AgrAgrDo agrAgrDo, List<AgrItem> updateAgrItems) {
        if (!CollectionUtils.isEmpty(updateAgrItems)) {
            agrAgrDo.setAgrItem(updateAgrItems);
            this.iAgrAgrModel.updateAgrItemByBatch(agrAgrDo);
            ArrayList skuChangePriceBOs = new ArrayList();
            updateAgrItems.forEach(agrItem -> {
                AgrSkuChangePriceBO agrSkuChangePriceBO = new AgrSkuChangePriceBO();
                agrSkuChangePriceBO.setAgreementId(agrAgrDo.getAgrId());
                agrSkuChangePriceBO.setAgreementSkuId(agrItem.getAgrItemId());
                try {
                    agrSkuChangePriceBO.setSalePrice(MoneyUtils.BigDecimal2Long((BigDecimal)agrItem.getSalePrice()));
                    agrSkuChangePriceBO.setBuyPrice(MoneyUtils.BigDecimal2Long((BigDecimal)agrItem.getBuyPrice()));
                }
                catch (Exception e) {
                    log.info(e.getMessage());
                }
                skuChangePriceBOs.add(agrSkuChangePriceBO);
            });
            HashMap content = new HashMap();
            content.put("skuChangePriceBOs", skuChangePriceBOs);
            this.sendMsg(JSON.toJSONString(content));
        }
    }

    private void dealItemDelete(AgrAgrDo agrAgrDo, List<Long> deleteAgrItemIds) {
        if (!CollectionUtils.isEmpty(deleteAgrItemIds)) {
            ArrayList<AgrItem> addAgrItem1 = new ArrayList<AgrItem>();
            AgrItem agrItem = new AgrItem();
            agrItem.setAgrItemIds(deleteAgrItemIds);
            addAgrItem1.add(agrItem);
            agrAgrDo.setAgrItem(addAgrItem1);
            this.iAgrAgrModel.deleteAgrItemByBatch(agrAgrDo);
            HashMap<String, Object> content = new HashMap<String, Object>();
            ArrayList<Long> agreementIds = new ArrayList<Long>();
            agreementIds.add(agrAgrDo.getAgrId());
            content.put("agreementIds", agreementIds);
            content.put("commiditySkuStatus", AgrCommConstant.CommiditySkuStatus.AGREEMENT_INVALID);
            content.put("agreementSkuIds", deleteAgrItemIds);
            this.sendMsg(JSON.toJSONString(content));
        }
    }

    private void sendMsg(String content) {
        if (StringUtils.hasText((String)content)) {
            log.info("\u53d1\u6d88\u606f\u540c\u6b65\u5546\u54c1\u5546\u54c1\u4e2d\u5fc3\u5165\u53c2\u4e3a" + content);
            this.agrSyncSkuStatusMqServiceProvider.send(new ProxyMessage(this.agrSkuChangeTopic, this.agrSkuChangeTag, content));
            log.info("\u53d1\u6d88\u606f\u540c\u6b65\u5546\u54c1\u5546\u54c1\u4e2d\u5fc3\u6210\u529f");
        }
    }
}

