/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service.domainservice;

import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.procinst.AgrProcInstDo;
import com.tydic.dyc.agr.model.procinst.IAgrProcInstModel;
import com.tydic.dyc.agr.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import com.tydic.dyc.agr.service.domainservice.AgrSupComfirmAgrService;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSupComfirmAgrReqBO;
import com.tydic.dyc.agr.service.domainservice.bo.AgrSupComfirmAgrRspBO;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AGR_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.domainservice.AgrSupComfirmAgrService"})
public class AgrSupComfirmAgrServiceImpl
implements AgrSupComfirmAgrService {
    @Autowired
    private IAgrProcInstModel iAgrProcInstModel;
    @Autowired
    private IAgrAgrModel iAgrAgrModel;

    @PostMapping(value={"dealSupComfirm"})
    public AgrSupComfirmAgrRspBO dealSupComfirm(@RequestBody AgrSupComfirmAgrReqBO reqBO) {
        this.validParam(reqBO);
        this.invokeUpdateTask(reqBO);
        this.invokeUpdateAgrMain(reqBO);
        return AgrRu.success(AgrSupComfirmAgrRspBO.class);
    }

    private void invokeUpdateAgrMain(AgrSupComfirmAgrReqBO reqBO) {
        AgrAgrDo agrAgrDo = new AgrAgrDo();
        agrAgrDo.setAgrId(reqBO.getAgrId());
        agrAgrDo.setConfirmTime(new Date());
        agrAgrDo.setConfirmName(reqBO.getName());
        this.iAgrAgrModel.updateAgrMain(agrAgrDo);
    }

    private void invokeUpdateTask(AgrSupComfirmAgrReqBO reqBO) {
        AgrProcInstDo agrProcInstDo = new AgrProcInstDo();
        ArrayList<UocOrderTaskInst> agrUocOrderTaskInsts = new ArrayList<UocOrderTaskInst>();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setObjId(reqBO.getAgrId());
        uocOrderTaskInst.setOrderId(reqBO.getAgrId());
        uocOrderTaskInst.setTaskInstId(reqBO.getTaskId());
        uocOrderTaskInst.setDealOperId(reqBO.getUserId());
        uocOrderTaskInst.setDealOperName(reqBO.getName());
        uocOrderTaskInst.setDealResult(reqBO.getConfirmResult());
        uocOrderTaskInst.setFinishTag(AgrCommConstant.taskFinishFLag.FINISHED);
        uocOrderTaskInst.setFinishTime(new Date());
        agrUocOrderTaskInsts.add(uocOrderTaskInst);
        agrProcInstDo.setAgrUocOrderTaskInst(agrUocOrderTaskInsts);
        this.iAgrProcInstModel.updateTask(agrProcInstDo);
    }

    private void validParam(AgrSupComfirmAgrReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getAgrId() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2agrId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getConfirmResult() == null) {
            throw new BaseBusinessException("0001", "\u5165\u53c2confirmResult\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
            throw new BaseBusinessException("0001", "\u5165\u53c2taskId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

