/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscAccessory;
import com.tydic.dyc.ssc.service.scheme.SscSchemeEndService;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeChangeBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeEndReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeEndRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscSchemeEndService"})
public class SscSchemeEndServiceImpl
implements SscSchemeEndService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @PostMapping(value={"dealSchemeEnd"})
    public SscSchemeEndRspBO dealSchemeEnd(@RequestBody SscSchemeEndReqBO sscSchemeEndReqBO) {
        this.check(sscSchemeEndReqBO);
        SscSchemeEndRspBO rspBO = SscRu.success(SscSchemeEndRspBO.class);
        SscSchemeChangeBO changeBO = SscRu.js(sscSchemeEndReqBO, SscSchemeChangeBO.class);
        changeBO.setOperType(SscCommConstant.OperTypeEnum.END.getCode());
        changeBO.setSscAccessory(SscRu.jsl(sscSchemeEndReqBO.getSscAccessory(), SscAccessory.class));
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        sscSchemeDo.setUserId(sscSchemeEndReqBO.getUserId());
        sscSchemeDo.setName(sscSchemeEndReqBO.getName());
        sscSchemeDo.setUsername(sscSchemeEndReqBO.getUsername());
        sscSchemeDo.setSchemeId(sscSchemeEndReqBO.getSchemeId());
        sscSchemeDo.setSchemeStatus(SscCommConstant.SchemeStatus.END.getCode());
        sscSchemeDo.setSscSchemeChange(Collections.singletonList(changeBO));
        this.iSscSchemeModel.dealSchemeEnd(sscSchemeDo);
        return rspBO;
    }

    private void check(SscSchemeEndReqBO reqBO) {
        if (ObjectUtil.isNull((Object)reqBO.getSchemeId())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[schemeId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

