/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.scheme.SscUpdateSchemeService;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdateSchemeRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscUpdateSchemeService"})
public class SscUpdateSchemeServiceImpl
implements SscUpdateSchemeService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;
    @Autowired
    private ISscCommonModel iSscCommonModel;

    @PostMapping(value={"updateScheme"})
    public SscUpdateSchemeRspBO updateScheme(@RequestBody SscUpdateSchemeReqBO sscUpdateSchemeReqBO0) {
        SscUpdateSchemeRspBO rspBO = SscRu.success(SscUpdateSchemeRspBO.class);
        SscSchemeDo updateDo = SscRu.js(sscUpdateSchemeReqBO0, SscSchemeDo.class);
        updateDo.setOperTime(new Date());
        this.iSscSchemeModel.updateScheme(updateDo);
        SscSchemeDo copyDo = new SscSchemeDo();
        copyDo.setSchemeId(sscUpdateSchemeReqBO0.getSchemeId());
        this.iSscSchemeModel.copyScheme(copyDo);
        this.deleteExtInfo(sscUpdateSchemeReqBO0);
        this.addExtInfo(sscUpdateSchemeReqBO0);
        return rspBO;
    }

    private void addExtInfo(SscUpdateSchemeReqBO reqBO) {
        List packList;
        List extFieldList = reqBO.getExtFields();
        ArrayList<SscExtObjInfo> extObjInfoList = new ArrayList<SscExtObjInfo>();
        SscCommonDo sscCommonDo = new SscCommonDo();
        if (CollectionUtil.isNotEmpty((Collection)extFieldList)) {
            SscExtObjInfo objInfo = new SscExtObjInfo();
            objInfo.setObjId(reqBO.getSchemeId());
            objInfo.setObjType("ssc_scheme_ext");
            objInfo.setExtInfo(SscRu.jsl(extFieldList, SscExtInfo.class));
            extObjInfoList.add(objInfo);
        }
        if (CollectionUtil.isNotEmpty((Collection)(packList = reqBO.getSscSchemePack()))) {
            List packExtObjInfoList = packList.stream().filter(e -> CollectionUtil.isNotEmpty((Collection)e.getExtFields())).map(e -> {
                List packExtFieldList = e.getExtFields();
                SscExtObjInfo objInfo = new SscExtObjInfo();
                objInfo.setObjId(e.getPackId());
                objInfo.setObjType("ssc_scheme_pack_ext");
                objInfo.setExtInfo(SscRu.jsl(packExtFieldList, SscExtInfo.class));
                return objInfo;
            }).collect(Collectors.toList());
            extObjInfoList.addAll(packExtObjInfoList);
        }
        if (CollectionUtil.isNotEmpty(extObjInfoList)) {
            sscCommonDo.setExtObjInfos(extObjInfoList);
            this.iSscCommonModel.addExtInfo(sscCommonDo);
        }
    }

    private void deleteExtInfo(SscUpdateSchemeReqBO reqBO) {
        SscExtObjInfo objInfo = new SscExtObjInfo();
        objInfo.setOrderId(reqBO.getSchemeId());
        objInfo.setObjType("ssc_scheme_ext");
        SscCommonDo sscCommonDo = new SscCommonDo();
        sscCommonDo.setExtObjInfos(Collections.singletonList(objInfo));
        this.iSscCommonModel.deleteExtInfo(sscCommonDo);
    }
}

