package com.tydic.dyc.ssc.model.scheme.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscQrySchemeInviteSupListReqBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscQrySchemeInviteSupListRspBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscQrySchemeMatListReqBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscSchemeQryBo;
import com.tydic.dyc.ssc.repository.SscSchemeRepository;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackListRspBO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.tydic.dyc.ssc.model.scheme.qrybo.*;
import org.springframework.stereotype.Service;

/**
 * 标题:ISscSchemeModelImpl
 * 说明:采购方案领域方法层
 * 时间:2022/11/10 10:28
 * 作者:罗有
 */

@Service
public class ISscSchemeModelImpl implements ISscSchemeModel {
	@Autowired
	private SscSchemeRepository sscSchemeRepository;
	@Override
	public SscQrySchemeMatListRspBO qrySchemeMatList(SscQrySchemeMatListReqBO reqBO) {
		// 方案明细分页查询
		return this.sscSchemeRepository.qrySchemeMatList(reqBO);
	}

	@Override
	public SscSchemeDo qrySchemeMainInfo(SscSchemeQryBo sscSchemeQryBo0) {
		return sscSchemeRepository.qrySchemeMainInfo(sscSchemeQryBo0);
	}

	@Override
	public void addSchemeMain(SscSchemeDo sscSchemeDo) {
       sscSchemeRepository.addScheme(sscSchemeDo);
	}

	@Override
	public void updateScheme(SscSchemeDo sscSchemeDo0) {
		sscSchemeRepository.updateScheme(sscSchemeDo0);
	}

	@Override
	public void addSchemeMatBatch(SscSchemeDo sscSchemeDo0) {
		this.sscSchemeRepository.addSchemeMatBatch(sscSchemeDo0);
	}

	@Override
	public void copyScheme(SscSchemeDo sscSchemeDo) {
		sscSchemeRepository.copyScheme(sscSchemeDo);
	}

	@Override
	public void updateSchemeMatBatch(SscSchemeDo sscSchemeDo0) {
		this.sscSchemeRepository.updateSchemeMatBatch(sscSchemeDo0);
	}

	@Override
	public void deleteSchemeMatBatch(SscSchemeDo sscSchemeDo0) {
		this.sscSchemeRepository.deleteSchemeMatBatch(sscSchemeDo0);
	}

	@Override
	public SscSchemeDo qrySchemePlanList(SscSchemeQryBo sscSchemeQryBo0) {
		return sscSchemeRepository.qrySchemePlanList(sscSchemeQryBo0);
	}

	@Override
	public SscQrySchemeInviteSupListRspBO qrySchemeInviteSupList(SscQrySchemeInviteSupListReqBO sscQrySchemeInviteSupListReqBO0) {

		SscQrySchemeInviteSupListReqBO reqBO = JSON.parseObject(JSON.toJSONString(sscQrySchemeInviteSupListReqBO0), SscQrySchemeInviteSupListReqBO.class);
		return sscSchemeRepository.qrySchemeInviteSupList(reqBO);

	}

	@Override
	public void addSchemeInviteSupBatch(SscSchemeDo sscSchemeDo0) {
		sscSchemeRepository.addSchemeInviteSupBatch(sscSchemeDo0);
	}

	@Override
	public void deleteSchemeInviteSupBatch(SscSchemeDo sscSchemeDo0) {
		if (sscSchemeDo0.getSchemeId() == null){
			throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[schemeId]不能为空");
		}
		sscSchemeRepository.deleteSchemeInviteSupBatch(sscSchemeDo0);
	}

	@Override
	public void deleteScheme(SscSchemeDo sscSchemeDo0) {
		sscSchemeRepository.deleteScheme(sscSchemeDo0);
	}

	@Override
	public SscSchemeDo qrySchemeDetail(SscSchemeQryBo sscSchemeQryBo0) {
		return sscSchemeRepository.qrySchemeDetail(sscSchemeQryBo0);
	}

	@Override
	public void copySchemeToDraft(SscSchemeDo sscSchemeDo) {
		this.sscSchemeRepository.copySchemeToDraft(sscSchemeDo);
	}

	@Override
	public SscSchemeDo qrySchemeAcceptRecordList(SchemeAcceptRecordQryBo schemeAcceptRecordQryBo) {
		SscSchemeQryBo qryBo = new SscSchemeQryBo();
		BeanUtils.copyProperties(schemeAcceptRecordQryBo,qryBo);
		return sscSchemeRepository.qrySchemeAcceptRecordList(qryBo);
	}

	@Override
	public void updateSchemeMain(SscSchemeDo sscSchemeDo) {
		sscSchemeRepository.updateSchemeMain(sscSchemeDo);
	}

	@Override
	public void addSchemeAcceptRecord(SscSchemeDo sscSchemeDo) {
		sscSchemeRepository.addSchemeAcceptRecord(sscSchemeDo);

	}

	@Override
	public void addSchemeEntrustRecord(SscSchemeDo sscSchemeDo) {
		sscSchemeRepository.addSchemeEntrustRecord(sscSchemeDo);
	}

	@Override
	public SscSchemeDo qrySchemeEntrustRecordList(SscSchemeEntrustRecordQryBo sscSchemeEntrustRecordQryBo) {
		return sscSchemeRepository.qrySchemeEntrustRecordList(sscSchemeEntrustRecordQryBo);
	}

	@Override
	public void updateSchemeMatBatchUnNullValue(SscSchemeDo sscSchemeDo) {
		this.sscSchemeRepository.updateSchemeMatBatch(sscSchemeDo);
	}

	@Override
	public void setSchemeMatNullValue(SscSchemeDo sscSchemeDo) {
		this.sscSchemeRepository.setSchemeMatNullValue(sscSchemeDo);
	}

	@Override
	public SscQrySchemeVersionListRspBO qrySchemeVersionList(SscSchemeQryBo sscSchemeQryBo) {
		return sscSchemeRepository.qrySchemeVersionList(sscSchemeQryBo);
	}

	@Override
	public void dealSchemeChange(SscSchemeDo sscSchemeDo) {
		sscSchemeRepository.schemeChange(sscSchemeDo);
	}

	@Override
	public void dealSchemePutUp(SscSchemeDo sscSchemeDo) {
		sscSchemeRepository.schemePutUp(sscSchemeDo);
	}

	@Override
	public void dealSchemeCancelPutUp(SscSchemeDo sscSchemeDo) {
		sscSchemeRepository.schemeCancelPutUp(sscSchemeDo);
	}

	@Override
	public void updateImpl(SscSchemeDo sscSchemeDo) {
		sscSchemeRepository.updateImpl(sscSchemeDo);
	}

	@Override
	public SscQrySchemePackListRspBO qrySchemePackList(SscSchemePackQryBo sscSchemePackQryBo) {
		return sscSchemeRepository.qrySchemePackList(sscSchemePackQryBo);
	}


	@Override
	public SscSchemeDo qrySchemeChangeList(SscSchemeQryBo sscSchemeQryBo) {
		return sscSchemeRepository.qrySchemeChangeList(sscSchemeQryBo);
	}

	@Override
	public void updatePackMain(SscSchemeDo sscSchemeDo) {
		sscSchemeRepository.updatePackMain(sscSchemeDo);
	}

	@Override
	public void dealSchemeEnd(SscSchemeDo sscSchemeDo) {
		sscSchemeRepository.dealSchemeEnd(sscSchemeDo);
	}

	@Override
	public void addSchemeChangeInfo(SscSchemeDo sscSchemeDo) {
		sscSchemeRepository.addSchemeChangeInfo(sscSchemeDo);
	}

	@Override
	public SscQrySchemeMainInfoListRspBO qrySchemeMainInfoList(SscQrySchemeMainInfoListReqBO sscQrySchemeMainInfoListReqBO) {
		return sscSchemeRepository.qrySchemeMainInfoList(sscQrySchemeMainInfoListReqBO);
	}

	@Override
	public SscQrySchemeChangeListBatchRspBO qrySchemeChangeListBatch(SscQrySchemeChangeListBatchReqBO sscQrySchemeChangeListBatchReqBO) {
		return this.sscSchemeRepository.qrySchemeChangeListBatch(sscQrySchemeChangeListBatchReqBO);
	}

	@Override
	public SscSchemeDo setEsMount(SscSetSchemeMatNullValueBatchReqBO reqBO) {
		return this.sscSchemeRepository.setEsMount(reqBO);
	}


}
